package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait M2tsArib {
  def unwrap: software.amazon.awssdk.services.medialive.model.M2tsArib
}
object M2tsArib {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.M2tsArib
  ): zio.aws.medialive.model.M2tsArib = value match {
    case software.amazon.awssdk.services.medialive.model.M2tsArib.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.M2tsArib.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.medialive.model.M2tsArib.ENABLED =>
      val r = ENABLED
      r
  }
  case object unknownToSdkVersion extends zio.aws.medialive.model.M2tsArib {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.M2tsArib =
      software.amazon.awssdk.services.medialive.model.M2tsArib.UNKNOWN_TO_SDK_VERSION
  }
  case object DISABLED extends zio.aws.medialive.model.M2tsArib {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.M2tsArib =
      software.amazon.awssdk.services.medialive.model.M2tsArib.DISABLED
  }
  case object ENABLED extends zio.aws.medialive.model.M2tsArib {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.M2tsArib =
      software.amazon.awssdk.services.medialive.model.M2tsArib.ENABLED
  }
}
