package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait M2tsAudioBufferModel {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.M2tsAudioBufferModel
}
object M2tsAudioBufferModel {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.M2tsAudioBufferModel
  ): zio.aws.medialive.model.M2tsAudioBufferModel = value match {
    case software.amazon.awssdk.services.medialive.model.M2tsAudioBufferModel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.M2tsAudioBufferModel.ATSC =>
      val r = ATSC
      r
    case software.amazon.awssdk.services.medialive.model.M2tsAudioBufferModel.DVB =>
      val r = DVB
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.M2tsAudioBufferModel {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.M2tsAudioBufferModel =
      software.amazon.awssdk.services.medialive.model.M2tsAudioBufferModel.UNKNOWN_TO_SDK_VERSION
  }
  case object ATSC extends zio.aws.medialive.model.M2tsAudioBufferModel {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.M2tsAudioBufferModel =
      software.amazon.awssdk.services.medialive.model.M2tsAudioBufferModel.ATSC
  }
  case object DVB extends zio.aws.medialive.model.M2tsAudioBufferModel {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.M2tsAudioBufferModel =
      software.amazon.awssdk.services.medialive.model.M2tsAudioBufferModel.DVB
  }
}
