package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait M2tsAudioInterval {
  def unwrap: software.amazon.awssdk.services.medialive.model.M2tsAudioInterval
}
object M2tsAudioInterval {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.M2tsAudioInterval
  ): zio.aws.medialive.model.M2tsAudioInterval = value match {
    case software.amazon.awssdk.services.medialive.model.M2tsAudioInterval.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.M2tsAudioInterval.VIDEO_AND_FIXED_INTERVALS =>
      val r = VIDEO_AND_FIXED_INTERVALS
      r
    case software.amazon.awssdk.services.medialive.model.M2tsAudioInterval.VIDEO_INTERVAL =>
      val r = VIDEO_INTERVAL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.M2tsAudioInterval {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.M2tsAudioInterval =
      software.amazon.awssdk.services.medialive.model.M2tsAudioInterval.UNKNOWN_TO_SDK_VERSION
  }
  case object VIDEO_AND_FIXED_INTERVALS
      extends zio.aws.medialive.model.M2tsAudioInterval {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.M2tsAudioInterval =
      software.amazon.awssdk.services.medialive.model.M2tsAudioInterval.VIDEO_AND_FIXED_INTERVALS
  }
  case object VIDEO_INTERVAL extends zio.aws.medialive.model.M2tsAudioInterval {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.M2tsAudioInterval =
      software.amazon.awssdk.services.medialive.model.M2tsAudioInterval.VIDEO_INTERVAL
  }
}
