package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait M2tsAudioStreamType {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.M2tsAudioStreamType
}
object M2tsAudioStreamType {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.M2tsAudioStreamType
  ): zio.aws.medialive.model.M2tsAudioStreamType = value match {
    case software.amazon.awssdk.services.medialive.model.M2tsAudioStreamType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.M2tsAudioStreamType.ATSC =>
      val r = ATSC
      r
    case software.amazon.awssdk.services.medialive.model.M2tsAudioStreamType.DVB =>
      val r = DVB
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.M2tsAudioStreamType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.M2tsAudioStreamType =
      software.amazon.awssdk.services.medialive.model.M2tsAudioStreamType.UNKNOWN_TO_SDK_VERSION
  }
  case object ATSC extends zio.aws.medialive.model.M2tsAudioStreamType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.M2tsAudioStreamType =
      software.amazon.awssdk.services.medialive.model.M2tsAudioStreamType.ATSC
  }
  case object DVB extends zio.aws.medialive.model.M2tsAudioStreamType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.M2tsAudioStreamType =
      software.amazon.awssdk.services.medialive.model.M2tsAudioStreamType.DVB
  }
}
