package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait M2tsBufferModel {
  def unwrap: software.amazon.awssdk.services.medialive.model.M2tsBufferModel
}
object M2tsBufferModel {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.M2tsBufferModel
  ): zio.aws.medialive.model.M2tsBufferModel = value match {
    case software.amazon.awssdk.services.medialive.model.M2tsBufferModel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.M2tsBufferModel.MULTIPLEX =>
      val r = MULTIPLEX
      r
    case software.amazon.awssdk.services.medialive.model.M2tsBufferModel.NONE =>
      val r = NONE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.M2tsBufferModel {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.M2tsBufferModel =
      software.amazon.awssdk.services.medialive.model.M2tsBufferModel.UNKNOWN_TO_SDK_VERSION
  }
  case object MULTIPLEX extends zio.aws.medialive.model.M2tsBufferModel {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.M2tsBufferModel =
      software.amazon.awssdk.services.medialive.model.M2tsBufferModel.MULTIPLEX
  }
  case object NONE extends zio.aws.medialive.model.M2tsBufferModel {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.M2tsBufferModel =
      software.amazon.awssdk.services.medialive.model.M2tsBufferModel.NONE
  }
}
