package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait M2tsCcDescriptor {
  def unwrap: software.amazon.awssdk.services.medialive.model.M2tsCcDescriptor
}
object M2tsCcDescriptor {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.M2tsCcDescriptor
  ): zio.aws.medialive.model.M2tsCcDescriptor = value match {
    case software.amazon.awssdk.services.medialive.model.M2tsCcDescriptor.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.M2tsCcDescriptor.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.medialive.model.M2tsCcDescriptor.ENABLED =>
      val r = ENABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.M2tsCcDescriptor {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.M2tsCcDescriptor =
      software.amazon.awssdk.services.medialive.model.M2tsCcDescriptor.UNKNOWN_TO_SDK_VERSION
  }
  case object DISABLED extends zio.aws.medialive.model.M2tsCcDescriptor {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.M2tsCcDescriptor =
      software.amazon.awssdk.services.medialive.model.M2tsCcDescriptor.DISABLED
  }
  case object ENABLED extends zio.aws.medialive.model.M2tsCcDescriptor {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.M2tsCcDescriptor =
      software.amazon.awssdk.services.medialive.model.M2tsCcDescriptor.ENABLED
  }
}
