package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait M2tsKlv {
  def unwrap: software.amazon.awssdk.services.medialive.model.M2tsKlv
}
object M2tsKlv {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.M2tsKlv
  ): zio.aws.medialive.model.M2tsKlv = value match {
    case software.amazon.awssdk.services.medialive.model.M2tsKlv.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.M2tsKlv.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.medialive.model.M2tsKlv.PASSTHROUGH =>
      val r = PASSTHROUGH
      r
  }
  case object unknownToSdkVersion extends zio.aws.medialive.model.M2tsKlv {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.M2tsKlv =
      software.amazon.awssdk.services.medialive.model.M2tsKlv.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.medialive.model.M2tsKlv {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.M2tsKlv =
      software.amazon.awssdk.services.medialive.model.M2tsKlv.NONE
  }
  case object PASSTHROUGH extends zio.aws.medialive.model.M2tsKlv {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.M2tsKlv =
      software.amazon.awssdk.services.medialive.model.M2tsKlv.PASSTHROUGH
  }
}
