package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait M2tsPcrControl {
  def unwrap: software.amazon.awssdk.services.medialive.model.M2tsPcrControl
}
object M2tsPcrControl {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.M2tsPcrControl
  ): zio.aws.medialive.model.M2tsPcrControl = value match {
    case software.amazon.awssdk.services.medialive.model.M2tsPcrControl.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.M2tsPcrControl.CONFIGURED_PCR_PERIOD =>
      val r = CONFIGURED_PCR_PERIOD
      r
    case software.amazon.awssdk.services.medialive.model.M2tsPcrControl.PCR_EVERY_PES_PACKET =>
      val r = PCR_EVERY_PES_PACKET
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.M2tsPcrControl {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.M2tsPcrControl =
      software.amazon.awssdk.services.medialive.model.M2tsPcrControl.UNKNOWN_TO_SDK_VERSION
  }
  case object CONFIGURED_PCR_PERIOD
      extends zio.aws.medialive.model.M2tsPcrControl {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.M2tsPcrControl =
      software.amazon.awssdk.services.medialive.model.M2tsPcrControl.CONFIGURED_PCR_PERIOD
  }
  case object PCR_EVERY_PES_PACKET
      extends zio.aws.medialive.model.M2tsPcrControl {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.M2tsPcrControl =
      software.amazon.awssdk.services.medialive.model.M2tsPcrControl.PCR_EVERY_PES_PACKET
  }
}
