package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait M2tsRateMode {
  def unwrap: software.amazon.awssdk.services.medialive.model.M2tsRateMode
}
object M2tsRateMode {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.M2tsRateMode
  ): zio.aws.medialive.model.M2tsRateMode = value match {
    case software.amazon.awssdk.services.medialive.model.M2tsRateMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.M2tsRateMode.CBR =>
      val r = CBR
      r
    case software.amazon.awssdk.services.medialive.model.M2tsRateMode.VBR =>
      val r = VBR
      r
  }
  case object unknownToSdkVersion extends zio.aws.medialive.model.M2tsRateMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.M2tsRateMode =
      software.amazon.awssdk.services.medialive.model.M2tsRateMode.UNKNOWN_TO_SDK_VERSION
  }
  case object CBR extends zio.aws.medialive.model.M2tsRateMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.M2tsRateMode =
      software.amazon.awssdk.services.medialive.model.M2tsRateMode.CBR
  }
  case object VBR extends zio.aws.medialive.model.M2tsRateMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.M2tsRateMode =
      software.amazon.awssdk.services.medialive.model.M2tsRateMode.VBR
  }
}
