package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait M2tsSegmentationStyle {
  def unwrap
      : software.amazon.awssdk.services.medialive.model.M2tsSegmentationStyle
}
object M2tsSegmentationStyle {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.M2tsSegmentationStyle
  ): zio.aws.medialive.model.M2tsSegmentationStyle = value match {
    case software.amazon.awssdk.services.medialive.model.M2tsSegmentationStyle.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.M2tsSegmentationStyle.MAINTAIN_CADENCE =>
      val r = MAINTAIN_CADENCE
      r
    case software.amazon.awssdk.services.medialive.model.M2tsSegmentationStyle.RESET_CADENCE =>
      val r = RESET_CADENCE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.M2tsSegmentationStyle {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.M2tsSegmentationStyle =
      software.amazon.awssdk.services.medialive.model.M2tsSegmentationStyle.UNKNOWN_TO_SDK_VERSION
  }
  case object MAINTAIN_CADENCE
      extends zio.aws.medialive.model.M2tsSegmentationStyle {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.M2tsSegmentationStyle =
      software.amazon.awssdk.services.medialive.model.M2tsSegmentationStyle.MAINTAIN_CADENCE
  }
  case object RESET_CADENCE
      extends zio.aws.medialive.model.M2tsSegmentationStyle {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.M2tsSegmentationStyle =
      software.amazon.awssdk.services.medialive.model.M2tsSegmentationStyle.RESET_CADENCE
  }
}
