package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{
  __integerMin0Max1000,
  __doubleMin1,
  __integerMin0Max65535,
  __integerMin0,
  __string,
  __doubleMin0,
  __integerMin0Max500,
  __integerMin0Max10000
}
import scala.jdk.CollectionConverters._
final case class M2tsSettings(
    absentInputAudioBehavior: Option[
      zio.aws.medialive.model.M2tsAbsentInputAudioBehavior
    ] = None,
    arib: Option[zio.aws.medialive.model.M2tsArib] = None,
    aribCaptionsPid: Option[__string] = None,
    aribCaptionsPidControl: Option[
      zio.aws.medialive.model.M2tsAribCaptionsPidControl
    ] = None,
    audioBufferModel: Option[zio.aws.medialive.model.M2tsAudioBufferModel] =
      None,
    audioFramesPerPes: Option[__integerMin0] = None,
    audioPids: Option[__string] = None,
    audioStreamType: Option[zio.aws.medialive.model.M2tsAudioStreamType] = None,
    bitrate: Option[__integerMin0] = None,
    bufferModel: Option[zio.aws.medialive.model.M2tsBufferModel] = None,
    ccDescriptor: Option[zio.aws.medialive.model.M2tsCcDescriptor] = None,
    dvbNitSettings: Option[zio.aws.medialive.model.DvbNitSettings] = None,
    dvbSdtSettings: Option[zio.aws.medialive.model.DvbSdtSettings] = None,
    dvbSubPids: Option[__string] = None,
    dvbTdtSettings: Option[zio.aws.medialive.model.DvbTdtSettings] = None,
    dvbTeletextPid: Option[__string] = None,
    ebif: Option[zio.aws.medialive.model.M2tsEbifControl] = None,
    ebpAudioInterval: Option[zio.aws.medialive.model.M2tsAudioInterval] = None,
    ebpLookaheadMs: Option[__integerMin0Max10000] = None,
    ebpPlacement: Option[zio.aws.medialive.model.M2tsEbpPlacement] = None,
    ecmPid: Option[__string] = None,
    esRateInPes: Option[zio.aws.medialive.model.M2tsEsRateInPes] = None,
    etvPlatformPid: Option[__string] = None,
    etvSignalPid: Option[__string] = None,
    fragmentTime: Option[__doubleMin0] = None,
    klv: Option[zio.aws.medialive.model.M2tsKlv] = None,
    klvDataPids: Option[__string] = None,
    nielsenId3Behavior: Option[zio.aws.medialive.model.M2tsNielsenId3Behavior] =
      None,
    nullPacketBitrate: Option[__doubleMin0] = None,
    patInterval: Option[__integerMin0Max1000] = None,
    pcrControl: Option[zio.aws.medialive.model.M2tsPcrControl] = None,
    pcrPeriod: Option[__integerMin0Max500] = None,
    pcrPid: Option[__string] = None,
    pmtInterval: Option[__integerMin0Max1000] = None,
    pmtPid: Option[__string] = None,
    programNum: Option[__integerMin0Max65535] = None,
    rateMode: Option[zio.aws.medialive.model.M2tsRateMode] = None,
    scte27Pids: Option[__string] = None,
    scte35Control: Option[zio.aws.medialive.model.M2tsScte35Control] = None,
    scte35Pid: Option[__string] = None,
    segmentationMarkers: Option[
      zio.aws.medialive.model.M2tsSegmentationMarkers
    ] = None,
    segmentationStyle: Option[zio.aws.medialive.model.M2tsSegmentationStyle] =
      None,
    segmentationTime: Option[__doubleMin1] = None,
    timedMetadataBehavior: Option[
      zio.aws.medialive.model.M2tsTimedMetadataBehavior
    ] = None,
    timedMetadataPid: Option[__string] = None,
    transportStreamId: Option[__integerMin0Max65535] = None,
    videoPid: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.M2tsSettings = {
    import M2tsSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.M2tsSettings
      .builder()
      .optionallyWith(absentInputAudioBehavior.map(value => value.unwrap))(
        _.absentInputAudioBehavior
      )
      .optionallyWith(arib.map(value => value.unwrap))(_.arib)
      .optionallyWith(aribCaptionsPid.map(value => value: java.lang.String))(
        _.aribCaptionsPid
      )
      .optionallyWith(aribCaptionsPidControl.map(value => value.unwrap))(
        _.aribCaptionsPidControl
      )
      .optionallyWith(audioBufferModel.map(value => value.unwrap))(
        _.audioBufferModel
      )
      .optionallyWith(audioFramesPerPes.map(value => value: Integer))(
        _.audioFramesPerPes
      )
      .optionallyWith(audioPids.map(value => value: java.lang.String))(
        _.audioPids
      )
      .optionallyWith(audioStreamType.map(value => value.unwrap))(
        _.audioStreamType
      )
      .optionallyWith(bitrate.map(value => value: Integer))(_.bitrate)
      .optionallyWith(bufferModel.map(value => value.unwrap))(_.bufferModel)
      .optionallyWith(ccDescriptor.map(value => value.unwrap))(_.ccDescriptor)
      .optionallyWith(dvbNitSettings.map(value => value.buildAwsValue()))(
        _.dvbNitSettings
      )
      .optionallyWith(dvbSdtSettings.map(value => value.buildAwsValue()))(
        _.dvbSdtSettings
      )
      .optionallyWith(dvbSubPids.map(value => value: java.lang.String))(
        _.dvbSubPids
      )
      .optionallyWith(dvbTdtSettings.map(value => value.buildAwsValue()))(
        _.dvbTdtSettings
      )
      .optionallyWith(dvbTeletextPid.map(value => value: java.lang.String))(
        _.dvbTeletextPid
      )
      .optionallyWith(ebif.map(value => value.unwrap))(_.ebif)
      .optionallyWith(ebpAudioInterval.map(value => value.unwrap))(
        _.ebpAudioInterval
      )
      .optionallyWith(ebpLookaheadMs.map(value => value: Integer))(
        _.ebpLookaheadMs
      )
      .optionallyWith(ebpPlacement.map(value => value.unwrap))(_.ebpPlacement)
      .optionallyWith(ecmPid.map(value => value: java.lang.String))(_.ecmPid)
      .optionallyWith(esRateInPes.map(value => value.unwrap))(_.esRateInPes)
      .optionallyWith(etvPlatformPid.map(value => value: java.lang.String))(
        _.etvPlatformPid
      )
      .optionallyWith(etvSignalPid.map(value => value: java.lang.String))(
        _.etvSignalPid
      )
      .optionallyWith(fragmentTime.map(value => value: java.lang.Double))(
        _.fragmentTime
      )
      .optionallyWith(klv.map(value => value.unwrap))(_.klv)
      .optionallyWith(klvDataPids.map(value => value: java.lang.String))(
        _.klvDataPids
      )
      .optionallyWith(nielsenId3Behavior.map(value => value.unwrap))(
        _.nielsenId3Behavior
      )
      .optionallyWith(nullPacketBitrate.map(value => value: java.lang.Double))(
        _.nullPacketBitrate
      )
      .optionallyWith(patInterval.map(value => value: Integer))(_.patInterval)
      .optionallyWith(pcrControl.map(value => value.unwrap))(_.pcrControl)
      .optionallyWith(pcrPeriod.map(value => value: Integer))(_.pcrPeriod)
      .optionallyWith(pcrPid.map(value => value: java.lang.String))(_.pcrPid)
      .optionallyWith(pmtInterval.map(value => value: Integer))(_.pmtInterval)
      .optionallyWith(pmtPid.map(value => value: java.lang.String))(_.pmtPid)
      .optionallyWith(programNum.map(value => value: Integer))(_.programNum)
      .optionallyWith(rateMode.map(value => value.unwrap))(_.rateMode)
      .optionallyWith(scte27Pids.map(value => value: java.lang.String))(
        _.scte27Pids
      )
      .optionallyWith(scte35Control.map(value => value.unwrap))(_.scte35Control)
      .optionallyWith(scte35Pid.map(value => value: java.lang.String))(
        _.scte35Pid
      )
      .optionallyWith(segmentationMarkers.map(value => value.unwrap))(
        _.segmentationMarkers
      )
      .optionallyWith(segmentationStyle.map(value => value.unwrap))(
        _.segmentationStyle
      )
      .optionallyWith(segmentationTime.map(value => value: java.lang.Double))(
        _.segmentationTime
      )
      .optionallyWith(timedMetadataBehavior.map(value => value.unwrap))(
        _.timedMetadataBehavior
      )
      .optionallyWith(timedMetadataPid.map(value => value: java.lang.String))(
        _.timedMetadataPid
      )
      .optionallyWith(transportStreamId.map(value => value: Integer))(
        _.transportStreamId
      )
      .optionallyWith(videoPid.map(value => value: java.lang.String))(
        _.videoPid
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.M2tsSettings.ReadOnly =
    zio.aws.medialive.model.M2tsSettings.wrap(buildAwsValue())
}
object M2tsSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.M2tsSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.M2tsSettings =
      zio.aws.medialive.model.M2tsSettings(
        absentInputAudioBehavior.map(value => value),
        arib.map(value => value),
        aribCaptionsPid.map(value => value),
        aribCaptionsPidControl.map(value => value),
        audioBufferModel.map(value => value),
        audioFramesPerPes.map(value => value),
        audioPids.map(value => value),
        audioStreamType.map(value => value),
        bitrate.map(value => value),
        bufferModel.map(value => value),
        ccDescriptor.map(value => value),
        dvbNitSettings.map(value => value.asEditable),
        dvbSdtSettings.map(value => value.asEditable),
        dvbSubPids.map(value => value),
        dvbTdtSettings.map(value => value.asEditable),
        dvbTeletextPid.map(value => value),
        ebif.map(value => value),
        ebpAudioInterval.map(value => value),
        ebpLookaheadMs.map(value => value),
        ebpPlacement.map(value => value),
        ecmPid.map(value => value),
        esRateInPes.map(value => value),
        etvPlatformPid.map(value => value),
        etvSignalPid.map(value => value),
        fragmentTime.map(value => value),
        klv.map(value => value),
        klvDataPids.map(value => value),
        nielsenId3Behavior.map(value => value),
        nullPacketBitrate.map(value => value),
        patInterval.map(value => value),
        pcrControl.map(value => value),
        pcrPeriod.map(value => value),
        pcrPid.map(value => value),
        pmtInterval.map(value => value),
        pmtPid.map(value => value),
        programNum.map(value => value),
        rateMode.map(value => value),
        scte27Pids.map(value => value),
        scte35Control.map(value => value),
        scte35Pid.map(value => value),
        segmentationMarkers.map(value => value),
        segmentationStyle.map(value => value),
        segmentationTime.map(value => value),
        timedMetadataBehavior.map(value => value),
        timedMetadataPid.map(value => value),
        transportStreamId.map(value => value),
        videoPid.map(value => value)
      )
    def absentInputAudioBehavior
        : Option[zio.aws.medialive.model.M2tsAbsentInputAudioBehavior]
    def arib: Option[zio.aws.medialive.model.M2tsArib]
    def aribCaptionsPid: Option[__string]
    def aribCaptionsPidControl
        : Option[zio.aws.medialive.model.M2tsAribCaptionsPidControl]
    def audioBufferModel: Option[zio.aws.medialive.model.M2tsAudioBufferModel]
    def audioFramesPerPes: Option[__integerMin0]
    def audioPids: Option[__string]
    def audioStreamType: Option[zio.aws.medialive.model.M2tsAudioStreamType]
    def bitrate: Option[__integerMin0]
    def bufferModel: Option[zio.aws.medialive.model.M2tsBufferModel]
    def ccDescriptor: Option[zio.aws.medialive.model.M2tsCcDescriptor]
    def dvbNitSettings: Option[zio.aws.medialive.model.DvbNitSettings.ReadOnly]
    def dvbSdtSettings: Option[zio.aws.medialive.model.DvbSdtSettings.ReadOnly]
    def dvbSubPids: Option[__string]
    def dvbTdtSettings: Option[zio.aws.medialive.model.DvbTdtSettings.ReadOnly]
    def dvbTeletextPid: Option[__string]
    def ebif: Option[zio.aws.medialive.model.M2tsEbifControl]
    def ebpAudioInterval: Option[zio.aws.medialive.model.M2tsAudioInterval]
    def ebpLookaheadMs: Option[__integerMin0Max10000]
    def ebpPlacement: Option[zio.aws.medialive.model.M2tsEbpPlacement]
    def ecmPid: Option[__string]
    def esRateInPes: Option[zio.aws.medialive.model.M2tsEsRateInPes]
    def etvPlatformPid: Option[__string]
    def etvSignalPid: Option[__string]
    def fragmentTime: Option[__doubleMin0]
    def klv: Option[zio.aws.medialive.model.M2tsKlv]
    def klvDataPids: Option[__string]
    def nielsenId3Behavior
        : Option[zio.aws.medialive.model.M2tsNielsenId3Behavior]
    def nullPacketBitrate: Option[__doubleMin0]
    def patInterval: Option[__integerMin0Max1000]
    def pcrControl: Option[zio.aws.medialive.model.M2tsPcrControl]
    def pcrPeriod: Option[__integerMin0Max500]
    def pcrPid: Option[__string]
    def pmtInterval: Option[__integerMin0Max1000]
    def pmtPid: Option[__string]
    def programNum: Option[__integerMin0Max65535]
    def rateMode: Option[zio.aws.medialive.model.M2tsRateMode]
    def scte27Pids: Option[__string]
    def scte35Control: Option[zio.aws.medialive.model.M2tsScte35Control]
    def scte35Pid: Option[__string]
    def segmentationMarkers
        : Option[zio.aws.medialive.model.M2tsSegmentationMarkers]
    def segmentationStyle: Option[zio.aws.medialive.model.M2tsSegmentationStyle]
    def segmentationTime: Option[__doubleMin1]
    def timedMetadataBehavior
        : Option[zio.aws.medialive.model.M2tsTimedMetadataBehavior]
    def timedMetadataPid: Option[__string]
    def transportStreamId: Option[__integerMin0Max65535]
    def videoPid: Option[__string]
    def getAbsentInputAudioBehavior: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.M2tsAbsentInputAudioBehavior
    ] = AwsError.unwrapOptionField(
      "absentInputAudioBehavior",
      absentInputAudioBehavior
    )
    def getArib: ZIO[Any, AwsError, zio.aws.medialive.model.M2tsArib] =
      AwsError.unwrapOptionField("arib", arib)
    def getAribCaptionsPid: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("aribCaptionsPid", aribCaptionsPid)
    def getAribCaptionsPidControl: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.M2tsAribCaptionsPidControl
    ] = AwsError.unwrapOptionField(
      "aribCaptionsPidControl",
      aribCaptionsPidControl
    )
    def getAudioBufferModel
        : ZIO[Any, AwsError, zio.aws.medialive.model.M2tsAudioBufferModel] =
      AwsError.unwrapOptionField("audioBufferModel", audioBufferModel)
    def getAudioFramesPerPes: ZIO[Any, AwsError, __integerMin0] =
      AwsError.unwrapOptionField("audioFramesPerPes", audioFramesPerPes)
    def getAudioPids: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("audioPids", audioPids)
    def getAudioStreamType
        : ZIO[Any, AwsError, zio.aws.medialive.model.M2tsAudioStreamType] =
      AwsError.unwrapOptionField("audioStreamType", audioStreamType)
    def getBitrate: ZIO[Any, AwsError, __integerMin0] =
      AwsError.unwrapOptionField("bitrate", bitrate)
    def getBufferModel
        : ZIO[Any, AwsError, zio.aws.medialive.model.M2tsBufferModel] =
      AwsError.unwrapOptionField("bufferModel", bufferModel)
    def getCcDescriptor
        : ZIO[Any, AwsError, zio.aws.medialive.model.M2tsCcDescriptor] =
      AwsError.unwrapOptionField("ccDescriptor", ccDescriptor)
    def getDvbNitSettings
        : ZIO[Any, AwsError, zio.aws.medialive.model.DvbNitSettings.ReadOnly] =
      AwsError.unwrapOptionField("dvbNitSettings", dvbNitSettings)
    def getDvbSdtSettings
        : ZIO[Any, AwsError, zio.aws.medialive.model.DvbSdtSettings.ReadOnly] =
      AwsError.unwrapOptionField("dvbSdtSettings", dvbSdtSettings)
    def getDvbSubPids: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("dvbSubPids", dvbSubPids)
    def getDvbTdtSettings
        : ZIO[Any, AwsError, zio.aws.medialive.model.DvbTdtSettings.ReadOnly] =
      AwsError.unwrapOptionField("dvbTdtSettings", dvbTdtSettings)
    def getDvbTeletextPid: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("dvbTeletextPid", dvbTeletextPid)
    def getEbif: ZIO[Any, AwsError, zio.aws.medialive.model.M2tsEbifControl] =
      AwsError.unwrapOptionField("ebif", ebif)
    def getEbpAudioInterval
        : ZIO[Any, AwsError, zio.aws.medialive.model.M2tsAudioInterval] =
      AwsError.unwrapOptionField("ebpAudioInterval", ebpAudioInterval)
    def getEbpLookaheadMs: ZIO[Any, AwsError, __integerMin0Max10000] =
      AwsError.unwrapOptionField("ebpLookaheadMs", ebpLookaheadMs)
    def getEbpPlacement
        : ZIO[Any, AwsError, zio.aws.medialive.model.M2tsEbpPlacement] =
      AwsError.unwrapOptionField("ebpPlacement", ebpPlacement)
    def getEcmPid: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("ecmPid", ecmPid)
    def getEsRateInPes
        : ZIO[Any, AwsError, zio.aws.medialive.model.M2tsEsRateInPes] =
      AwsError.unwrapOptionField("esRateInPes", esRateInPes)
    def getEtvPlatformPid: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("etvPlatformPid", etvPlatformPid)
    def getEtvSignalPid: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("etvSignalPid", etvSignalPid)
    def getFragmentTime: ZIO[Any, AwsError, __doubleMin0] =
      AwsError.unwrapOptionField("fragmentTime", fragmentTime)
    def getKlv: ZIO[Any, AwsError, zio.aws.medialive.model.M2tsKlv] =
      AwsError.unwrapOptionField("klv", klv)
    def getKlvDataPids: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("klvDataPids", klvDataPids)
    def getNielsenId3Behavior
        : ZIO[Any, AwsError, zio.aws.medialive.model.M2tsNielsenId3Behavior] =
      AwsError.unwrapOptionField("nielsenId3Behavior", nielsenId3Behavior)
    def getNullPacketBitrate: ZIO[Any, AwsError, __doubleMin0] =
      AwsError.unwrapOptionField("nullPacketBitrate", nullPacketBitrate)
    def getPatInterval: ZIO[Any, AwsError, __integerMin0Max1000] =
      AwsError.unwrapOptionField("patInterval", patInterval)
    def getPcrControl
        : ZIO[Any, AwsError, zio.aws.medialive.model.M2tsPcrControl] =
      AwsError.unwrapOptionField("pcrControl", pcrControl)
    def getPcrPeriod: ZIO[Any, AwsError, __integerMin0Max500] =
      AwsError.unwrapOptionField("pcrPeriod", pcrPeriod)
    def getPcrPid: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("pcrPid", pcrPid)
    def getPmtInterval: ZIO[Any, AwsError, __integerMin0Max1000] =
      AwsError.unwrapOptionField("pmtInterval", pmtInterval)
    def getPmtPid: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("pmtPid", pmtPid)
    def getProgramNum: ZIO[Any, AwsError, __integerMin0Max65535] =
      AwsError.unwrapOptionField("programNum", programNum)
    def getRateMode: ZIO[Any, AwsError, zio.aws.medialive.model.M2tsRateMode] =
      AwsError.unwrapOptionField("rateMode", rateMode)
    def getScte27Pids: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("scte27Pids", scte27Pids)
    def getScte35Control
        : ZIO[Any, AwsError, zio.aws.medialive.model.M2tsScte35Control] =
      AwsError.unwrapOptionField("scte35Control", scte35Control)
    def getScte35Pid: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("scte35Pid", scte35Pid)
    def getSegmentationMarkers
        : ZIO[Any, AwsError, zio.aws.medialive.model.M2tsSegmentationMarkers] =
      AwsError.unwrapOptionField("segmentationMarkers", segmentationMarkers)
    def getSegmentationStyle
        : ZIO[Any, AwsError, zio.aws.medialive.model.M2tsSegmentationStyle] =
      AwsError.unwrapOptionField("segmentationStyle", segmentationStyle)
    def getSegmentationTime: ZIO[Any, AwsError, __doubleMin1] =
      AwsError.unwrapOptionField("segmentationTime", segmentationTime)
    def getTimedMetadataBehavior: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.M2tsTimedMetadataBehavior
    ] =
      AwsError.unwrapOptionField("timedMetadataBehavior", timedMetadataBehavior)
    def getTimedMetadataPid: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("timedMetadataPid", timedMetadataPid)
    def getTransportStreamId: ZIO[Any, AwsError, __integerMin0Max65535] =
      AwsError.unwrapOptionField("transportStreamId", transportStreamId)
    def getVideoPid: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("videoPid", videoPid)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.M2tsSettings
  ) extends zio.aws.medialive.model.M2tsSettings.ReadOnly {
    override val absentInputAudioBehavior
        : Option[zio.aws.medialive.model.M2tsAbsentInputAudioBehavior] = scala
      .Option(impl.absentInputAudioBehavior())
      .map(value =>
        zio.aws.medialive.model.M2tsAbsentInputAudioBehavior.wrap(value)
      )
    override val arib: Option[zio.aws.medialive.model.M2tsArib] = scala
      .Option(impl.arib())
      .map(value => zio.aws.medialive.model.M2tsArib.wrap(value))
    override val aribCaptionsPid: Option[__string] =
      scala.Option(impl.aribCaptionsPid()).map(value => value: __string)
    override val aribCaptionsPidControl
        : Option[zio.aws.medialive.model.M2tsAribCaptionsPidControl] = scala
      .Option(impl.aribCaptionsPidControl())
      .map(value =>
        zio.aws.medialive.model.M2tsAribCaptionsPidControl.wrap(value)
      )
    override val audioBufferModel
        : Option[zio.aws.medialive.model.M2tsAudioBufferModel] = scala
      .Option(impl.audioBufferModel())
      .map(value => zio.aws.medialive.model.M2tsAudioBufferModel.wrap(value))
    override val audioFramesPerPes: Option[__integerMin0] =
      scala.Option(impl.audioFramesPerPes()).map(value => value: __integerMin0)
    override val audioPids: Option[__string] =
      scala.Option(impl.audioPids()).map(value => value: __string)
    override val audioStreamType
        : Option[zio.aws.medialive.model.M2tsAudioStreamType] = scala
      .Option(impl.audioStreamType())
      .map(value => zio.aws.medialive.model.M2tsAudioStreamType.wrap(value))
    override val bitrate: Option[__integerMin0] =
      scala.Option(impl.bitrate()).map(value => value: __integerMin0)
    override val bufferModel: Option[zio.aws.medialive.model.M2tsBufferModel] =
      scala
        .Option(impl.bufferModel())
        .map(value => zio.aws.medialive.model.M2tsBufferModel.wrap(value))
    override val ccDescriptor
        : Option[zio.aws.medialive.model.M2tsCcDescriptor] = scala
      .Option(impl.ccDescriptor())
      .map(value => zio.aws.medialive.model.M2tsCcDescriptor.wrap(value))
    override val dvbNitSettings
        : Option[zio.aws.medialive.model.DvbNitSettings.ReadOnly] = scala
      .Option(impl.dvbNitSettings())
      .map(value => zio.aws.medialive.model.DvbNitSettings.wrap(value))
    override val dvbSdtSettings
        : Option[zio.aws.medialive.model.DvbSdtSettings.ReadOnly] = scala
      .Option(impl.dvbSdtSettings())
      .map(value => zio.aws.medialive.model.DvbSdtSettings.wrap(value))
    override val dvbSubPids: Option[__string] =
      scala.Option(impl.dvbSubPids()).map(value => value: __string)
    override val dvbTdtSettings
        : Option[zio.aws.medialive.model.DvbTdtSettings.ReadOnly] = scala
      .Option(impl.dvbTdtSettings())
      .map(value => zio.aws.medialive.model.DvbTdtSettings.wrap(value))
    override val dvbTeletextPid: Option[__string] =
      scala.Option(impl.dvbTeletextPid()).map(value => value: __string)
    override val ebif: Option[zio.aws.medialive.model.M2tsEbifControl] = scala
      .Option(impl.ebif())
      .map(value => zio.aws.medialive.model.M2tsEbifControl.wrap(value))
    override val ebpAudioInterval
        : Option[zio.aws.medialive.model.M2tsAudioInterval] = scala
      .Option(impl.ebpAudioInterval())
      .map(value => zio.aws.medialive.model.M2tsAudioInterval.wrap(value))
    override val ebpLookaheadMs: Option[__integerMin0Max10000] = scala
      .Option(impl.ebpLookaheadMs())
      .map(value => value: __integerMin0Max10000)
    override val ebpPlacement
        : Option[zio.aws.medialive.model.M2tsEbpPlacement] = scala
      .Option(impl.ebpPlacement())
      .map(value => zio.aws.medialive.model.M2tsEbpPlacement.wrap(value))
    override val ecmPid: Option[__string] =
      scala.Option(impl.ecmPid()).map(value => value: __string)
    override val esRateInPes: Option[zio.aws.medialive.model.M2tsEsRateInPes] =
      scala
        .Option(impl.esRateInPes())
        .map(value => zio.aws.medialive.model.M2tsEsRateInPes.wrap(value))
    override val etvPlatformPid: Option[__string] =
      scala.Option(impl.etvPlatformPid()).map(value => value: __string)
    override val etvSignalPid: Option[__string] =
      scala.Option(impl.etvSignalPid()).map(value => value: __string)
    override val fragmentTime: Option[__doubleMin0] =
      scala.Option(impl.fragmentTime()).map(value => value: __doubleMin0)
    override val klv: Option[zio.aws.medialive.model.M2tsKlv] = scala
      .Option(impl.klv())
      .map(value => zio.aws.medialive.model.M2tsKlv.wrap(value))
    override val klvDataPids: Option[__string] =
      scala.Option(impl.klvDataPids()).map(value => value: __string)
    override val nielsenId3Behavior
        : Option[zio.aws.medialive.model.M2tsNielsenId3Behavior] = scala
      .Option(impl.nielsenId3Behavior())
      .map(value => zio.aws.medialive.model.M2tsNielsenId3Behavior.wrap(value))
    override val nullPacketBitrate: Option[__doubleMin0] =
      scala.Option(impl.nullPacketBitrate()).map(value => value: __doubleMin0)
    override val patInterval: Option[__integerMin0Max1000] =
      scala.Option(impl.patInterval()).map(value => value: __integerMin0Max1000)
    override val pcrControl: Option[zio.aws.medialive.model.M2tsPcrControl] =
      scala
        .Option(impl.pcrControl())
        .map(value => zio.aws.medialive.model.M2tsPcrControl.wrap(value))
    override val pcrPeriod: Option[__integerMin0Max500] =
      scala.Option(impl.pcrPeriod()).map(value => value: __integerMin0Max500)
    override val pcrPid: Option[__string] =
      scala.Option(impl.pcrPid()).map(value => value: __string)
    override val pmtInterval: Option[__integerMin0Max1000] =
      scala.Option(impl.pmtInterval()).map(value => value: __integerMin0Max1000)
    override val pmtPid: Option[__string] =
      scala.Option(impl.pmtPid()).map(value => value: __string)
    override val programNum: Option[__integerMin0Max65535] =
      scala.Option(impl.programNum()).map(value => value: __integerMin0Max65535)
    override val rateMode: Option[zio.aws.medialive.model.M2tsRateMode] = scala
      .Option(impl.rateMode())
      .map(value => zio.aws.medialive.model.M2tsRateMode.wrap(value))
    override val scte27Pids: Option[__string] =
      scala.Option(impl.scte27Pids()).map(value => value: __string)
    override val scte35Control
        : Option[zio.aws.medialive.model.M2tsScte35Control] = scala
      .Option(impl.scte35Control())
      .map(value => zio.aws.medialive.model.M2tsScte35Control.wrap(value))
    override val scte35Pid: Option[__string] =
      scala.Option(impl.scte35Pid()).map(value => value: __string)
    override val segmentationMarkers
        : Option[zio.aws.medialive.model.M2tsSegmentationMarkers] = scala
      .Option(impl.segmentationMarkers())
      .map(value => zio.aws.medialive.model.M2tsSegmentationMarkers.wrap(value))
    override val segmentationStyle
        : Option[zio.aws.medialive.model.M2tsSegmentationStyle] = scala
      .Option(impl.segmentationStyle())
      .map(value => zio.aws.medialive.model.M2tsSegmentationStyle.wrap(value))
    override val segmentationTime: Option[__doubleMin1] =
      scala.Option(impl.segmentationTime()).map(value => value: __doubleMin1)
    override val timedMetadataBehavior
        : Option[zio.aws.medialive.model.M2tsTimedMetadataBehavior] = scala
      .Option(impl.timedMetadataBehavior())
      .map(value =>
        zio.aws.medialive.model.M2tsTimedMetadataBehavior.wrap(value)
      )
    override val timedMetadataPid: Option[__string] =
      scala.Option(impl.timedMetadataPid()).map(value => value: __string)
    override val transportStreamId: Option[__integerMin0Max65535] = scala
      .Option(impl.transportStreamId())
      .map(value => value: __integerMin0Max65535)
    override val videoPid: Option[__string] =
      scala.Option(impl.videoPid()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.M2tsSettings
  ): zio.aws.medialive.model.M2tsSettings.ReadOnly = new Wrapper(impl)
}
