package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait M3u8PcrControl {
  def unwrap: software.amazon.awssdk.services.medialive.model.M3u8PcrControl
}
object M3u8PcrControl {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.M3u8PcrControl
  ): zio.aws.medialive.model.M3u8PcrControl = value match {
    case software.amazon.awssdk.services.medialive.model.M3u8PcrControl.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.M3u8PcrControl.CONFIGURED_PCR_PERIOD =>
      val r = CONFIGURED_PCR_PERIOD
      r
    case software.amazon.awssdk.services.medialive.model.M3u8PcrControl.PCR_EVERY_PES_PACKET =>
      val r = PCR_EVERY_PES_PACKET
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.M3u8PcrControl {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.M3u8PcrControl =
      software.amazon.awssdk.services.medialive.model.M3u8PcrControl.UNKNOWN_TO_SDK_VERSION
  }
  case object CONFIGURED_PCR_PERIOD
      extends zio.aws.medialive.model.M3u8PcrControl {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.M3u8PcrControl =
      software.amazon.awssdk.services.medialive.model.M3u8PcrControl.CONFIGURED_PCR_PERIOD
  }
  case object PCR_EVERY_PES_PACKET
      extends zio.aws.medialive.model.M3u8PcrControl {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.M3u8PcrControl =
      software.amazon.awssdk.services.medialive.model.M3u8PcrControl.PCR_EVERY_PES_PACKET
  }
}
