package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{
  __integerMin0Max1000,
  __integerMin0Max65535,
  __integerMin0,
  __string,
  __integerMin0Max500
}
import scala.jdk.CollectionConverters._
final case class M3u8Settings(
    audioFramesPerPes: Option[__integerMin0] = None,
    audioPids: Option[__string] = None,
    ecmPid: Option[__string] = None,
    nielsenId3Behavior: Option[zio.aws.medialive.model.M3u8NielsenId3Behavior] =
      None,
    patInterval: Option[__integerMin0Max1000] = None,
    pcrControl: Option[zio.aws.medialive.model.M3u8PcrControl] = None,
    pcrPeriod: Option[__integerMin0Max500] = None,
    pcrPid: Option[__string] = None,
    pmtInterval: Option[__integerMin0Max1000] = None,
    pmtPid: Option[__string] = None,
    programNum: Option[__integerMin0Max65535] = None,
    scte35Behavior: Option[zio.aws.medialive.model.M3u8Scte35Behavior] = None,
    scte35Pid: Option[__string] = None,
    timedMetadataBehavior: Option[
      zio.aws.medialive.model.M3u8TimedMetadataBehavior
    ] = None,
    timedMetadataPid: Option[__string] = None,
    transportStreamId: Option[__integerMin0Max65535] = None,
    videoPid: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.M3u8Settings = {
    import M3u8Settings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.M3u8Settings
      .builder()
      .optionallyWith(audioFramesPerPes.map(value => value: Integer))(
        _.audioFramesPerPes
      )
      .optionallyWith(audioPids.map(value => value: java.lang.String))(
        _.audioPids
      )
      .optionallyWith(ecmPid.map(value => value: java.lang.String))(_.ecmPid)
      .optionallyWith(nielsenId3Behavior.map(value => value.unwrap))(
        _.nielsenId3Behavior
      )
      .optionallyWith(patInterval.map(value => value: Integer))(_.patInterval)
      .optionallyWith(pcrControl.map(value => value.unwrap))(_.pcrControl)
      .optionallyWith(pcrPeriod.map(value => value: Integer))(_.pcrPeriod)
      .optionallyWith(pcrPid.map(value => value: java.lang.String))(_.pcrPid)
      .optionallyWith(pmtInterval.map(value => value: Integer))(_.pmtInterval)
      .optionallyWith(pmtPid.map(value => value: java.lang.String))(_.pmtPid)
      .optionallyWith(programNum.map(value => value: Integer))(_.programNum)
      .optionallyWith(scte35Behavior.map(value => value.unwrap))(
        _.scte35Behavior
      )
      .optionallyWith(scte35Pid.map(value => value: java.lang.String))(
        _.scte35Pid
      )
      .optionallyWith(timedMetadataBehavior.map(value => value.unwrap))(
        _.timedMetadataBehavior
      )
      .optionallyWith(timedMetadataPid.map(value => value: java.lang.String))(
        _.timedMetadataPid
      )
      .optionallyWith(transportStreamId.map(value => value: Integer))(
        _.transportStreamId
      )
      .optionallyWith(videoPid.map(value => value: java.lang.String))(
        _.videoPid
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.M3u8Settings.ReadOnly =
    zio.aws.medialive.model.M3u8Settings.wrap(buildAwsValue())
}
object M3u8Settings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.M3u8Settings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.M3u8Settings =
      zio.aws.medialive.model.M3u8Settings(
        audioFramesPerPes.map(value => value),
        audioPids.map(value => value),
        ecmPid.map(value => value),
        nielsenId3Behavior.map(value => value),
        patInterval.map(value => value),
        pcrControl.map(value => value),
        pcrPeriod.map(value => value),
        pcrPid.map(value => value),
        pmtInterval.map(value => value),
        pmtPid.map(value => value),
        programNum.map(value => value),
        scte35Behavior.map(value => value),
        scte35Pid.map(value => value),
        timedMetadataBehavior.map(value => value),
        timedMetadataPid.map(value => value),
        transportStreamId.map(value => value),
        videoPid.map(value => value)
      )
    def audioFramesPerPes: Option[__integerMin0]
    def audioPids: Option[__string]
    def ecmPid: Option[__string]
    def nielsenId3Behavior
        : Option[zio.aws.medialive.model.M3u8NielsenId3Behavior]
    def patInterval: Option[__integerMin0Max1000]
    def pcrControl: Option[zio.aws.medialive.model.M3u8PcrControl]
    def pcrPeriod: Option[__integerMin0Max500]
    def pcrPid: Option[__string]
    def pmtInterval: Option[__integerMin0Max1000]
    def pmtPid: Option[__string]
    def programNum: Option[__integerMin0Max65535]
    def scte35Behavior: Option[zio.aws.medialive.model.M3u8Scte35Behavior]
    def scte35Pid: Option[__string]
    def timedMetadataBehavior
        : Option[zio.aws.medialive.model.M3u8TimedMetadataBehavior]
    def timedMetadataPid: Option[__string]
    def transportStreamId: Option[__integerMin0Max65535]
    def videoPid: Option[__string]
    def getAudioFramesPerPes: ZIO[Any, AwsError, __integerMin0] =
      AwsError.unwrapOptionField("audioFramesPerPes", audioFramesPerPes)
    def getAudioPids: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("audioPids", audioPids)
    def getEcmPid: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("ecmPid", ecmPid)
    def getNielsenId3Behavior
        : ZIO[Any, AwsError, zio.aws.medialive.model.M3u8NielsenId3Behavior] =
      AwsError.unwrapOptionField("nielsenId3Behavior", nielsenId3Behavior)
    def getPatInterval: ZIO[Any, AwsError, __integerMin0Max1000] =
      AwsError.unwrapOptionField("patInterval", patInterval)
    def getPcrControl
        : ZIO[Any, AwsError, zio.aws.medialive.model.M3u8PcrControl] =
      AwsError.unwrapOptionField("pcrControl", pcrControl)
    def getPcrPeriod: ZIO[Any, AwsError, __integerMin0Max500] =
      AwsError.unwrapOptionField("pcrPeriod", pcrPeriod)
    def getPcrPid: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("pcrPid", pcrPid)
    def getPmtInterval: ZIO[Any, AwsError, __integerMin0Max1000] =
      AwsError.unwrapOptionField("pmtInterval", pmtInterval)
    def getPmtPid: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("pmtPid", pmtPid)
    def getProgramNum: ZIO[Any, AwsError, __integerMin0Max65535] =
      AwsError.unwrapOptionField("programNum", programNum)
    def getScte35Behavior
        : ZIO[Any, AwsError, zio.aws.medialive.model.M3u8Scte35Behavior] =
      AwsError.unwrapOptionField("scte35Behavior", scte35Behavior)
    def getScte35Pid: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("scte35Pid", scte35Pid)
    def getTimedMetadataBehavior: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.M3u8TimedMetadataBehavior
    ] =
      AwsError.unwrapOptionField("timedMetadataBehavior", timedMetadataBehavior)
    def getTimedMetadataPid: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("timedMetadataPid", timedMetadataPid)
    def getTransportStreamId: ZIO[Any, AwsError, __integerMin0Max65535] =
      AwsError.unwrapOptionField("transportStreamId", transportStreamId)
    def getVideoPid: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("videoPid", videoPid)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.M3u8Settings
  ) extends zio.aws.medialive.model.M3u8Settings.ReadOnly {
    override val audioFramesPerPes: Option[__integerMin0] =
      scala.Option(impl.audioFramesPerPes()).map(value => value: __integerMin0)
    override val audioPids: Option[__string] =
      scala.Option(impl.audioPids()).map(value => value: __string)
    override val ecmPid: Option[__string] =
      scala.Option(impl.ecmPid()).map(value => value: __string)
    override val nielsenId3Behavior
        : Option[zio.aws.medialive.model.M3u8NielsenId3Behavior] = scala
      .Option(impl.nielsenId3Behavior())
      .map(value => zio.aws.medialive.model.M3u8NielsenId3Behavior.wrap(value))
    override val patInterval: Option[__integerMin0Max1000] =
      scala.Option(impl.patInterval()).map(value => value: __integerMin0Max1000)
    override val pcrControl: Option[zio.aws.medialive.model.M3u8PcrControl] =
      scala
        .Option(impl.pcrControl())
        .map(value => zio.aws.medialive.model.M3u8PcrControl.wrap(value))
    override val pcrPeriod: Option[__integerMin0Max500] =
      scala.Option(impl.pcrPeriod()).map(value => value: __integerMin0Max500)
    override val pcrPid: Option[__string] =
      scala.Option(impl.pcrPid()).map(value => value: __string)
    override val pmtInterval: Option[__integerMin0Max1000] =
      scala.Option(impl.pmtInterval()).map(value => value: __integerMin0Max1000)
    override val pmtPid: Option[__string] =
      scala.Option(impl.pmtPid()).map(value => value: __string)
    override val programNum: Option[__integerMin0Max65535] =
      scala.Option(impl.programNum()).map(value => value: __integerMin0Max65535)
    override val scte35Behavior
        : Option[zio.aws.medialive.model.M3u8Scte35Behavior] = scala
      .Option(impl.scte35Behavior())
      .map(value => zio.aws.medialive.model.M3u8Scte35Behavior.wrap(value))
    override val scte35Pid: Option[__string] =
      scala.Option(impl.scte35Pid()).map(value => value: __string)
    override val timedMetadataBehavior
        : Option[zio.aws.medialive.model.M3u8TimedMetadataBehavior] = scala
      .Option(impl.timedMetadataBehavior())
      .map(value =>
        zio.aws.medialive.model.M3u8TimedMetadataBehavior.wrap(value)
      )
    override val timedMetadataPid: Option[__string] =
      scala.Option(impl.timedMetadataPid()).map(value => value: __string)
    override val transportStreamId: Option[__integerMin0Max65535] = scala
      .Option(impl.transportStreamId())
      .map(value => value: __integerMin0Max65535)
    override val videoPid: Option[__string] =
      scala.Option(impl.videoPid()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.M3u8Settings
  ): zio.aws.medialive.model.M3u8Settings.ReadOnly = new Wrapper(impl)
}
