package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait M3u8TimedMetadataBehavior {
  def unwrap: software.amazon.awssdk.services.medialive.model.M3u8TimedMetadataBehavior
}
object M3u8TimedMetadataBehavior {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.M3u8TimedMetadataBehavior
  ): zio.aws.medialive.model.M3u8TimedMetadataBehavior = value match {
    case software.amazon.awssdk.services.medialive.model.M3u8TimedMetadataBehavior.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.M3u8TimedMetadataBehavior.NO_PASSTHROUGH =>
      val r = NO_PASSTHROUGH
      r
    case software.amazon.awssdk.services.medialive.model.M3u8TimedMetadataBehavior.PASSTHROUGH =>
      val r = PASSTHROUGH
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.M3u8TimedMetadataBehavior {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.M3u8TimedMetadataBehavior =
      software.amazon.awssdk.services.medialive.model.M3u8TimedMetadataBehavior.UNKNOWN_TO_SDK_VERSION
  }
  case object NO_PASSTHROUGH
      extends zio.aws.medialive.model.M3u8TimedMetadataBehavior {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.M3u8TimedMetadataBehavior =
      software.amazon.awssdk.services.medialive.model.M3u8TimedMetadataBehavior.NO_PASSTHROUGH
  }
  case object PASSTHROUGH
      extends zio.aws.medialive.model.M3u8TimedMetadataBehavior {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.M3u8TimedMetadataBehavior =
      software.amazon.awssdk.services.medialive.model.M3u8TimedMetadataBehavior.PASSTHROUGH
  }
}
