package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__stringPattern010920300
import scala.jdk.CollectionConverters._
final case class MaintenanceCreateSettings(
    maintenanceDay: Option[zio.aws.medialive.model.MaintenanceDay] = None,
    maintenanceStartTime: Option[__stringPattern010920300] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.MaintenanceCreateSettings = {
    import MaintenanceCreateSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.MaintenanceCreateSettings
      .builder()
      .optionallyWith(maintenanceDay.map(value => value.unwrap))(
        _.maintenanceDay
      )
      .optionallyWith(
        maintenanceStartTime.map(value => value: java.lang.String)
      )(_.maintenanceStartTime)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.MaintenanceCreateSettings.ReadOnly =
    zio.aws.medialive.model.MaintenanceCreateSettings.wrap(buildAwsValue())
}
object MaintenanceCreateSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.MaintenanceCreateSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.MaintenanceCreateSettings =
      zio.aws.medialive.model.MaintenanceCreateSettings(
        maintenanceDay.map(value => value),
        maintenanceStartTime.map(value => value)
      )
    def maintenanceDay: Option[zio.aws.medialive.model.MaintenanceDay]
    def maintenanceStartTime: Option[__stringPattern010920300]
    def getMaintenanceDay
        : ZIO[Any, AwsError, zio.aws.medialive.model.MaintenanceDay] =
      AwsError.unwrapOptionField("maintenanceDay", maintenanceDay)
    def getMaintenanceStartTime: ZIO[Any, AwsError, __stringPattern010920300] =
      AwsError.unwrapOptionField("maintenanceStartTime", maintenanceStartTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.MaintenanceCreateSettings
  ) extends zio.aws.medialive.model.MaintenanceCreateSettings.ReadOnly {
    override val maintenanceDay
        : Option[zio.aws.medialive.model.MaintenanceDay] = scala
      .Option(impl.maintenanceDay())
      .map(value => zio.aws.medialive.model.MaintenanceDay.wrap(value))
    override val maintenanceStartTime: Option[__stringPattern010920300] = scala
      .Option(impl.maintenanceStartTime())
      .map(value => value: __stringPattern010920300)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.MaintenanceCreateSettings
  ): zio.aws.medialive.model.MaintenanceCreateSettings.ReadOnly = new Wrapper(
    impl
  )
}
