package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class MaintenanceStatus(
    maintenanceDay: Option[zio.aws.medialive.model.MaintenanceDay] = None,
    maintenanceDeadline: Option[__string] = None,
    maintenanceScheduledDate: Option[__string] = None,
    maintenanceStartTime: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.MaintenanceStatus = {
    import MaintenanceStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.MaintenanceStatus
      .builder()
      .optionallyWith(maintenanceDay.map(value => value.unwrap))(
        _.maintenanceDay
      )
      .optionallyWith(
        maintenanceDeadline.map(value => value: java.lang.String)
      )(_.maintenanceDeadline)
      .optionallyWith(
        maintenanceScheduledDate.map(value => value: java.lang.String)
      )(_.maintenanceScheduledDate)
      .optionallyWith(
        maintenanceStartTime.map(value => value: java.lang.String)
      )(_.maintenanceStartTime)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.MaintenanceStatus.ReadOnly =
    zio.aws.medialive.model.MaintenanceStatus.wrap(buildAwsValue())
}
object MaintenanceStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.MaintenanceStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.MaintenanceStatus =
      zio.aws.medialive.model.MaintenanceStatus(
        maintenanceDay.map(value => value),
        maintenanceDeadline.map(value => value),
        maintenanceScheduledDate.map(value => value),
        maintenanceStartTime.map(value => value)
      )
    def maintenanceDay: Option[zio.aws.medialive.model.MaintenanceDay]
    def maintenanceDeadline: Option[__string]
    def maintenanceScheduledDate: Option[__string]
    def maintenanceStartTime: Option[__string]
    def getMaintenanceDay
        : ZIO[Any, AwsError, zio.aws.medialive.model.MaintenanceDay] =
      AwsError.unwrapOptionField("maintenanceDay", maintenanceDay)
    def getMaintenanceDeadline: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("maintenanceDeadline", maintenanceDeadline)
    def getMaintenanceScheduledDate: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("maintenanceScheduledDate", maintenanceScheduledDate)
    def getMaintenanceStartTime: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("maintenanceStartTime", maintenanceStartTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.MaintenanceStatus
  ) extends zio.aws.medialive.model.MaintenanceStatus.ReadOnly {
    override val maintenanceDay
        : Option[zio.aws.medialive.model.MaintenanceDay] = scala
      .Option(impl.maintenanceDay())
      .map(value => zio.aws.medialive.model.MaintenanceDay.wrap(value))
    override val maintenanceDeadline: Option[__string] =
      scala.Option(impl.maintenanceDeadline()).map(value => value: __string)
    override val maintenanceScheduledDate: Option[__string] = scala
      .Option(impl.maintenanceScheduledDate())
      .map(value => value: __string)
    override val maintenanceStartTime: Option[__string] =
      scala.Option(impl.maintenanceStartTime()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.MaintenanceStatus
  ): zio.aws.medialive.model.MaintenanceStatus.ReadOnly = new Wrapper(impl)
}
