package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{__stringPattern010920300, __string}
import scala.jdk.CollectionConverters._
final case class MaintenanceUpdateSettings(
    maintenanceDay: Option[zio.aws.medialive.model.MaintenanceDay] = None,
    maintenanceScheduledDate: Option[__string] = None,
    maintenanceStartTime: Option[__stringPattern010920300] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.MaintenanceUpdateSettings = {
    import MaintenanceUpdateSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.MaintenanceUpdateSettings
      .builder()
      .optionallyWith(maintenanceDay.map(value => value.unwrap))(
        _.maintenanceDay
      )
      .optionallyWith(
        maintenanceScheduledDate.map(value => value: java.lang.String)
      )(_.maintenanceScheduledDate)
      .optionallyWith(
        maintenanceStartTime.map(value => value: java.lang.String)
      )(_.maintenanceStartTime)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.MaintenanceUpdateSettings.ReadOnly =
    zio.aws.medialive.model.MaintenanceUpdateSettings.wrap(buildAwsValue())
}
object MaintenanceUpdateSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.MaintenanceUpdateSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.MaintenanceUpdateSettings =
      zio.aws.medialive.model.MaintenanceUpdateSettings(
        maintenanceDay.map(value => value),
        maintenanceScheduledDate.map(value => value),
        maintenanceStartTime.map(value => value)
      )
    def maintenanceDay: Option[zio.aws.medialive.model.MaintenanceDay]
    def maintenanceScheduledDate: Option[__string]
    def maintenanceStartTime: Option[__stringPattern010920300]
    def getMaintenanceDay
        : ZIO[Any, AwsError, zio.aws.medialive.model.MaintenanceDay] =
      AwsError.unwrapOptionField("maintenanceDay", maintenanceDay)
    def getMaintenanceScheduledDate: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("maintenanceScheduledDate", maintenanceScheduledDate)
    def getMaintenanceStartTime: ZIO[Any, AwsError, __stringPattern010920300] =
      AwsError.unwrapOptionField("maintenanceStartTime", maintenanceStartTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.MaintenanceUpdateSettings
  ) extends zio.aws.medialive.model.MaintenanceUpdateSettings.ReadOnly {
    override val maintenanceDay
        : Option[zio.aws.medialive.model.MaintenanceDay] = scala
      .Option(impl.maintenanceDay())
      .map(value => zio.aws.medialive.model.MaintenanceDay.wrap(value))
    override val maintenanceScheduledDate: Option[__string] = scala
      .Option(impl.maintenanceScheduledDate())
      .map(value => value: __string)
    override val maintenanceStartTime: Option[__stringPattern010920300] = scala
      .Option(impl.maintenanceStartTime())
      .map(value => value: __stringPattern010920300)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.MaintenanceUpdateSettings
  ): zio.aws.medialive.model.MaintenanceUpdateSettings.ReadOnly = new Wrapper(
    impl
  )
}
