package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class MediaConnectFlowRequest(flowArn: Option[__string] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.MediaConnectFlowRequest = {
    import MediaConnectFlowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.MediaConnectFlowRequest
      .builder()
      .optionallyWith(flowArn.map(value => value: java.lang.String))(_.flowArn)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.MediaConnectFlowRequest.ReadOnly =
    zio.aws.medialive.model.MediaConnectFlowRequest.wrap(buildAwsValue())
}
object MediaConnectFlowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.MediaConnectFlowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.MediaConnectFlowRequest =
      zio.aws.medialive.model
        .MediaConnectFlowRequest(flowArn.map(value => value))
    def flowArn: Option[__string]
    def getFlowArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("flowArn", flowArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.MediaConnectFlowRequest
  ) extends zio.aws.medialive.model.MediaConnectFlowRequest.ReadOnly {
    override val flowArn: Option[__string] =
      scala.Option(impl.flowArn()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.MediaConnectFlowRequest
  ): zio.aws.medialive.model.MediaConnectFlowRequest.ReadOnly = new Wrapper(
    impl
  )
}
