package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class MediaPackageGroupSettings(
    destination: zio.aws.medialive.model.OutputLocationRef
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.MediaPackageGroupSettings = {
    import MediaPackageGroupSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.MediaPackageGroupSettings
      .builder()
      .destination(destination.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.MediaPackageGroupSettings.ReadOnly =
    zio.aws.medialive.model.MediaPackageGroupSettings.wrap(buildAwsValue())
}
object MediaPackageGroupSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.MediaPackageGroupSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.MediaPackageGroupSettings =
      zio.aws.medialive.model.MediaPackageGroupSettings(destination.asEditable)
    def destination: zio.aws.medialive.model.OutputLocationRef.ReadOnly
    def getDestination: ZIO[
      Any,
      Nothing,
      zio.aws.medialive.model.OutputLocationRef.ReadOnly
    ] = ZIO.succeed(destination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.MediaPackageGroupSettings
  ) extends zio.aws.medialive.model.MediaPackageGroupSettings.ReadOnly {
    override val destination
        : zio.aws.medialive.model.OutputLocationRef.ReadOnly =
      zio.aws.medialive.model.OutputLocationRef.wrap(impl.destination())
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.MediaPackageGroupSettings
  ): zio.aws.medialive.model.MediaPackageGroupSettings.ReadOnly = new Wrapper(
    impl
  )
}
