package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__stringMin1
import scala.jdk.CollectionConverters._
final case class MediaPackageOutputDestinationSettings(
    channelId: Option[__stringMin1] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.MediaPackageOutputDestinationSettings = {
    import MediaPackageOutputDestinationSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.MediaPackageOutputDestinationSettings
      .builder()
      .optionallyWith(channelId.map(value => value: java.lang.String))(
        _.channelId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.medialive.model.MediaPackageOutputDestinationSettings.ReadOnly =
    zio.aws.medialive.model.MediaPackageOutputDestinationSettings
      .wrap(buildAwsValue())
}
object MediaPackageOutputDestinationSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.MediaPackageOutputDestinationSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.medialive.model.MediaPackageOutputDestinationSettings =
      zio.aws.medialive.model
        .MediaPackageOutputDestinationSettings(channelId.map(value => value))
    def channelId: Option[__stringMin1]
    def getChannelId: ZIO[Any, AwsError, __stringMin1] =
      AwsError.unwrapOptionField("channelId", channelId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.MediaPackageOutputDestinationSettings
  ) extends zio.aws.medialive.model.MediaPackageOutputDestinationSettings.ReadOnly {
    override val channelId: Option[__stringMin1] =
      scala.Option(impl.channelId()).map(value => value: __stringMin1)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.MediaPackageOutputDestinationSettings
  ): zio.aws.medialive.model.MediaPackageOutputDestinationSettings.ReadOnly =
    new Wrapper(impl)
}
