package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{__string, __longMin0Max86400000}
import scala.jdk.CollectionConverters._
final case class MotionGraphicsActivateScheduleActionSettings(
    duration: Option[__longMin0Max86400000] = None,
    passwordParam: Option[__string] = None,
    url: Option[__string] = None,
    username: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.MotionGraphicsActivateScheduleActionSettings = {
    import MotionGraphicsActivateScheduleActionSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.MotionGraphicsActivateScheduleActionSettings
      .builder()
      .optionallyWith(duration.map(value => value: java.lang.Long))(_.duration)
      .optionallyWith(passwordParam.map(value => value: java.lang.String))(
        _.passwordParam
      )
      .optionallyWith(url.map(value => value: java.lang.String))(_.url)
      .optionallyWith(username.map(value => value: java.lang.String))(
        _.username
      )
      .build()
  }
  def asReadOnly
      : zio.aws.medialive.model.MotionGraphicsActivateScheduleActionSettings.ReadOnly =
    zio.aws.medialive.model.MotionGraphicsActivateScheduleActionSettings
      .wrap(buildAwsValue())
}
object MotionGraphicsActivateScheduleActionSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.MotionGraphicsActivateScheduleActionSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.medialive.model.MotionGraphicsActivateScheduleActionSettings =
      zio.aws.medialive.model.MotionGraphicsActivateScheduleActionSettings(
        duration.map(value => value),
        passwordParam.map(value => value),
        url.map(value => value),
        username.map(value => value)
      )
    def duration: Option[__longMin0Max86400000]
    def passwordParam: Option[__string]
    def url: Option[__string]
    def username: Option[__string]
    def getDuration: ZIO[Any, AwsError, __longMin0Max86400000] =
      AwsError.unwrapOptionField("duration", duration)
    def getPasswordParam: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("passwordParam", passwordParam)
    def getUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("url", url)
    def getUsername: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("username", username)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.MotionGraphicsActivateScheduleActionSettings
  ) extends zio.aws.medialive.model.MotionGraphicsActivateScheduleActionSettings.ReadOnly {
    override val duration: Option[__longMin0Max86400000] =
      scala.Option(impl.duration()).map(value => value: __longMin0Max86400000)
    override val passwordParam: Option[__string] =
      scala.Option(impl.passwordParam()).map(value => value: __string)
    override val url: Option[__string] =
      scala.Option(impl.url()).map(value => value: __string)
    override val username: Option[__string] =
      scala.Option(impl.username()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.MotionGraphicsActivateScheduleActionSettings
  ): zio.aws.medialive.model.MotionGraphicsActivateScheduleActionSettings.ReadOnly =
    new Wrapper(impl)
}
