package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MotionGraphicsConfiguration(
    motionGraphicsInsertion: Option[
      zio.aws.medialive.model.MotionGraphicsInsertion
    ] = None,
    motionGraphicsSettings: zio.aws.medialive.model.MotionGraphicsSettings
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.MotionGraphicsConfiguration = {
    import MotionGraphicsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.MotionGraphicsConfiguration
      .builder()
      .optionallyWith(motionGraphicsInsertion.map(value => value.unwrap))(
        _.motionGraphicsInsertion
      )
      .motionGraphicsSettings(motionGraphicsSettings.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.MotionGraphicsConfiguration.ReadOnly =
    zio.aws.medialive.model.MotionGraphicsConfiguration.wrap(buildAwsValue())
}
object MotionGraphicsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.MotionGraphicsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.MotionGraphicsConfiguration =
      zio.aws.medialive.model.MotionGraphicsConfiguration(
        motionGraphicsInsertion.map(value => value),
        motionGraphicsSettings.asEditable
      )
    def motionGraphicsInsertion
        : Option[zio.aws.medialive.model.MotionGraphicsInsertion]
    def motionGraphicsSettings
        : zio.aws.medialive.model.MotionGraphicsSettings.ReadOnly
    def getMotionGraphicsInsertion
        : ZIO[Any, AwsError, zio.aws.medialive.model.MotionGraphicsInsertion] =
      AwsError.unwrapOptionField(
        "motionGraphicsInsertion",
        motionGraphicsInsertion
      )
    def getMotionGraphicsSettings: ZIO[
      Any,
      Nothing,
      zio.aws.medialive.model.MotionGraphicsSettings.ReadOnly
    ] = ZIO.succeed(motionGraphicsSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.MotionGraphicsConfiguration
  ) extends zio.aws.medialive.model.MotionGraphicsConfiguration.ReadOnly {
    override val motionGraphicsInsertion
        : Option[zio.aws.medialive.model.MotionGraphicsInsertion] = scala
      .Option(impl.motionGraphicsInsertion())
      .map(value => zio.aws.medialive.model.MotionGraphicsInsertion.wrap(value))
    override val motionGraphicsSettings
        : zio.aws.medialive.model.MotionGraphicsSettings.ReadOnly =
      zio.aws.medialive.model.MotionGraphicsSettings
        .wrap(impl.motionGraphicsSettings())
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.MotionGraphicsConfiguration
  ): zio.aws.medialive.model.MotionGraphicsConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
