package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MotionGraphicsSettings(
    htmlMotionGraphicsSettings: Option[
      zio.aws.medialive.model.HtmlMotionGraphicsSettings
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.MotionGraphicsSettings = {
    import MotionGraphicsSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.MotionGraphicsSettings
      .builder()
      .optionallyWith(
        htmlMotionGraphicsSettings.map(value => value.buildAwsValue())
      )(_.htmlMotionGraphicsSettings)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.MotionGraphicsSettings.ReadOnly =
    zio.aws.medialive.model.MotionGraphicsSettings.wrap(buildAwsValue())
}
object MotionGraphicsSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.MotionGraphicsSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.MotionGraphicsSettings =
      zio.aws.medialive.model.MotionGraphicsSettings(
        htmlMotionGraphicsSettings.map(value => value.asEditable)
      )
    def htmlMotionGraphicsSettings
        : Option[zio.aws.medialive.model.HtmlMotionGraphicsSettings.ReadOnly]
    def getHtmlMotionGraphicsSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.HtmlMotionGraphicsSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "htmlMotionGraphicsSettings",
      htmlMotionGraphicsSettings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.MotionGraphicsSettings
  ) extends zio.aws.medialive.model.MotionGraphicsSettings.ReadOnly {
    override val htmlMotionGraphicsSettings
        : Option[zio.aws.medialive.model.HtmlMotionGraphicsSettings.ReadOnly] =
      scala
        .Option(impl.htmlMotionGraphicsSettings())
        .map(value =>
          zio.aws.medialive.model.HtmlMotionGraphicsSettings.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.MotionGraphicsSettings
  ): zio.aws.medialive.model.MotionGraphicsSettings.ReadOnly = new Wrapper(impl)
}
