package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait Mp2CodingMode {
  def unwrap: software.amazon.awssdk.services.medialive.model.Mp2CodingMode
}
object Mp2CodingMode {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.Mp2CodingMode
  ): zio.aws.medialive.model.Mp2CodingMode = value match {
    case software.amazon.awssdk.services.medialive.model.Mp2CodingMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.Mp2CodingMode.CODING_MODE_1_0 =>
      val r = CODING_MODE_1_0
      r
    case software.amazon.awssdk.services.medialive.model.Mp2CodingMode.CODING_MODE_2_0 =>
      val r = CODING_MODE_2_0
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.Mp2CodingMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Mp2CodingMode =
      software.amazon.awssdk.services.medialive.model.Mp2CodingMode.UNKNOWN_TO_SDK_VERSION
  }
  case object CODING_MODE_1_0 extends zio.aws.medialive.model.Mp2CodingMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Mp2CodingMode =
      software.amazon.awssdk.services.medialive.model.Mp2CodingMode.CODING_MODE_1_0
  }
  case object CODING_MODE_2_0 extends zio.aws.medialive.model.Mp2CodingMode {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Mp2CodingMode =
      software.amazon.awssdk.services.medialive.model.Mp2CodingMode.CODING_MODE_2_0
  }
}
