package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__double
import scala.jdk.CollectionConverters._
final case class Mp2Settings(
    bitrate: Option[__double] = None,
    codingMode: Option[zio.aws.medialive.model.Mp2CodingMode] = None,
    sampleRate: Option[__double] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.Mp2Settings = {
    import Mp2Settings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.Mp2Settings
      .builder()
      .optionallyWith(bitrate.map(value => value: java.lang.Double))(_.bitrate)
      .optionallyWith(codingMode.map(value => value.unwrap))(_.codingMode)
      .optionallyWith(sampleRate.map(value => value: java.lang.Double))(
        _.sampleRate
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.Mp2Settings.ReadOnly =
    zio.aws.medialive.model.Mp2Settings.wrap(buildAwsValue())
}
object Mp2Settings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.Mp2Settings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.Mp2Settings =
      zio.aws.medialive.model.Mp2Settings(
        bitrate.map(value => value),
        codingMode.map(value => value),
        sampleRate.map(value => value)
      )
    def bitrate: Option[__double]
    def codingMode: Option[zio.aws.medialive.model.Mp2CodingMode]
    def sampleRate: Option[__double]
    def getBitrate: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("bitrate", bitrate)
    def getCodingMode
        : ZIO[Any, AwsError, zio.aws.medialive.model.Mp2CodingMode] =
      AwsError.unwrapOptionField("codingMode", codingMode)
    def getSampleRate: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("sampleRate", sampleRate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.Mp2Settings
  ) extends zio.aws.medialive.model.Mp2Settings.ReadOnly {
    override val bitrate: Option[__double] =
      scala.Option(impl.bitrate()).map(value => value: __double)
    override val codingMode: Option[zio.aws.medialive.model.Mp2CodingMode] =
      scala
        .Option(impl.codingMode())
        .map(value => zio.aws.medialive.model.Mp2CodingMode.wrap(value))
    override val sampleRate: Option[__double] =
      scala.Option(impl.sampleRate()).map(value => value: __double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.Mp2Settings
  ): zio.aws.medialive.model.Mp2Settings.ReadOnly = new Wrapper(impl)
}
