package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait Mpeg2AdaptiveQuantization {
  def unwrap: software.amazon.awssdk.services.medialive.model.Mpeg2AdaptiveQuantization
}
object Mpeg2AdaptiveQuantization {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.Mpeg2AdaptiveQuantization
  ): zio.aws.medialive.model.Mpeg2AdaptiveQuantization = value match {
    case software.amazon.awssdk.services.medialive.model.Mpeg2AdaptiveQuantization.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.Mpeg2AdaptiveQuantization.AUTO =>
      val r = AUTO
      r
    case software.amazon.awssdk.services.medialive.model.Mpeg2AdaptiveQuantization.HIGH =>
      val r = HIGH
      r
    case software.amazon.awssdk.services.medialive.model.Mpeg2AdaptiveQuantization.LOW =>
      val r = LOW
      r
    case software.amazon.awssdk.services.medialive.model.Mpeg2AdaptiveQuantization.MEDIUM =>
      val r = MEDIUM
      r
    case software.amazon.awssdk.services.medialive.model.Mpeg2AdaptiveQuantization.OFF =>
      val r = OFF
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.Mpeg2AdaptiveQuantization {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Mpeg2AdaptiveQuantization =
      software.amazon.awssdk.services.medialive.model.Mpeg2AdaptiveQuantization.UNKNOWN_TO_SDK_VERSION
  }
  case object AUTO extends zio.aws.medialive.model.Mpeg2AdaptiveQuantization {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Mpeg2AdaptiveQuantization =
      software.amazon.awssdk.services.medialive.model.Mpeg2AdaptiveQuantization.AUTO
  }
  case object HIGH extends zio.aws.medialive.model.Mpeg2AdaptiveQuantization {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Mpeg2AdaptiveQuantization =
      software.amazon.awssdk.services.medialive.model.Mpeg2AdaptiveQuantization.HIGH
  }
  case object LOW extends zio.aws.medialive.model.Mpeg2AdaptiveQuantization {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Mpeg2AdaptiveQuantization =
      software.amazon.awssdk.services.medialive.model.Mpeg2AdaptiveQuantization.LOW
  }
  case object MEDIUM extends zio.aws.medialive.model.Mpeg2AdaptiveQuantization {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Mpeg2AdaptiveQuantization =
      software.amazon.awssdk.services.medialive.model.Mpeg2AdaptiveQuantization.MEDIUM
  }
  case object OFF extends zio.aws.medialive.model.Mpeg2AdaptiveQuantization {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Mpeg2AdaptiveQuantization =
      software.amazon.awssdk.services.medialive.model.Mpeg2AdaptiveQuantization.OFF
  }
}
