package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait Mpeg2ColorMetadata {
  def unwrap: software.amazon.awssdk.services.medialive.model.Mpeg2ColorMetadata
}
object Mpeg2ColorMetadata {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.Mpeg2ColorMetadata
  ): zio.aws.medialive.model.Mpeg2ColorMetadata = value match {
    case software.amazon.awssdk.services.medialive.model.Mpeg2ColorMetadata.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.Mpeg2ColorMetadata.IGNORE =>
      val r = IGNORE
      r
    case software.amazon.awssdk.services.medialive.model.Mpeg2ColorMetadata.INSERT =>
      val r = INSERT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.Mpeg2ColorMetadata {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Mpeg2ColorMetadata =
      software.amazon.awssdk.services.medialive.model.Mpeg2ColorMetadata.UNKNOWN_TO_SDK_VERSION
  }
  case object IGNORE extends zio.aws.medialive.model.Mpeg2ColorMetadata {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Mpeg2ColorMetadata =
      software.amazon.awssdk.services.medialive.model.Mpeg2ColorMetadata.IGNORE
  }
  case object INSERT extends zio.aws.medialive.model.Mpeg2ColorMetadata {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Mpeg2ColorMetadata =
      software.amazon.awssdk.services.medialive.model.Mpeg2ColorMetadata.INSERT
  }
}
