package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait Mpeg2ColorSpace {
  def unwrap: software.amazon.awssdk.services.medialive.model.Mpeg2ColorSpace
}
object Mpeg2ColorSpace {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.Mpeg2ColorSpace
  ): zio.aws.medialive.model.Mpeg2ColorSpace = value match {
    case software.amazon.awssdk.services.medialive.model.Mpeg2ColorSpace.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.Mpeg2ColorSpace.AUTO =>
      val r = AUTO
      r
    case software.amazon.awssdk.services.medialive.model.Mpeg2ColorSpace.PASSTHROUGH =>
      val r = PASSTHROUGH
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.Mpeg2ColorSpace {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Mpeg2ColorSpace =
      software.amazon.awssdk.services.medialive.model.Mpeg2ColorSpace.UNKNOWN_TO_SDK_VERSION
  }
  case object AUTO extends zio.aws.medialive.model.Mpeg2ColorSpace {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Mpeg2ColorSpace =
      software.amazon.awssdk.services.medialive.model.Mpeg2ColorSpace.AUTO
  }
  case object PASSTHROUGH extends zio.aws.medialive.model.Mpeg2ColorSpace {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Mpeg2ColorSpace =
      software.amazon.awssdk.services.medialive.model.Mpeg2ColorSpace.PASSTHROUGH
  }
}
