package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait Mpeg2DisplayRatio {
  def unwrap: software.amazon.awssdk.services.medialive.model.Mpeg2DisplayRatio
}
object Mpeg2DisplayRatio {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.Mpeg2DisplayRatio
  ): zio.aws.medialive.model.Mpeg2DisplayRatio = value match {
    case software.amazon.awssdk.services.medialive.model.Mpeg2DisplayRatio.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.Mpeg2DisplayRatio.DISPLAYRATIO16_X9 =>
      val r = DISPLAYRATIO16X9
      r
    case software.amazon.awssdk.services.medialive.model.Mpeg2DisplayRatio.DISPLAYRATIO4_X3 =>
      val r = DISPLAYRATIO4X3
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.Mpeg2DisplayRatio {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Mpeg2DisplayRatio =
      software.amazon.awssdk.services.medialive.model.Mpeg2DisplayRatio.UNKNOWN_TO_SDK_VERSION
  }
  case object DISPLAYRATIO16X9
      extends zio.aws.medialive.model.Mpeg2DisplayRatio {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Mpeg2DisplayRatio =
      software.amazon.awssdk.services.medialive.model.Mpeg2DisplayRatio.DISPLAYRATIO16_X9
  }
  case object DISPLAYRATIO4X3
      extends zio.aws.medialive.model.Mpeg2DisplayRatio {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Mpeg2DisplayRatio =
      software.amazon.awssdk.services.medialive.model.Mpeg2DisplayRatio.DISPLAYRATIO4_X3
  }
}
