package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Mpeg2FilterSettings(
    temporalFilterSettings: Option[
      zio.aws.medialive.model.TemporalFilterSettings
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.Mpeg2FilterSettings = {
    import Mpeg2FilterSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.Mpeg2FilterSettings
      .builder()
      .optionallyWith(
        temporalFilterSettings.map(value => value.buildAwsValue())
      )(_.temporalFilterSettings)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.Mpeg2FilterSettings.ReadOnly =
    zio.aws.medialive.model.Mpeg2FilterSettings.wrap(buildAwsValue())
}
object Mpeg2FilterSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.Mpeg2FilterSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.Mpeg2FilterSettings =
      zio.aws.medialive.model.Mpeg2FilterSettings(
        temporalFilterSettings.map(value => value.asEditable)
      )
    def temporalFilterSettings
        : Option[zio.aws.medialive.model.TemporalFilterSettings.ReadOnly]
    def getTemporalFilterSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.TemporalFilterSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "temporalFilterSettings",
      temporalFilterSettings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.Mpeg2FilterSettings
  ) extends zio.aws.medialive.model.Mpeg2FilterSettings.ReadOnly {
    override val temporalFilterSettings
        : Option[zio.aws.medialive.model.TemporalFilterSettings.ReadOnly] =
      scala
        .Option(impl.temporalFilterSettings())
        .map(value =>
          zio.aws.medialive.model.TemporalFilterSettings.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.Mpeg2FilterSettings
  ): zio.aws.medialive.model.Mpeg2FilterSettings.ReadOnly = new Wrapper(impl)
}
