package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait Mpeg2GopSizeUnits {
  def unwrap: software.amazon.awssdk.services.medialive.model.Mpeg2GopSizeUnits
}
object Mpeg2GopSizeUnits {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.Mpeg2GopSizeUnits
  ): zio.aws.medialive.model.Mpeg2GopSizeUnits = value match {
    case software.amazon.awssdk.services.medialive.model.Mpeg2GopSizeUnits.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.Mpeg2GopSizeUnits.FRAMES =>
      val r = FRAMES
      r
    case software.amazon.awssdk.services.medialive.model.Mpeg2GopSizeUnits.SECONDS =>
      val r = SECONDS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.Mpeg2GopSizeUnits {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Mpeg2GopSizeUnits =
      software.amazon.awssdk.services.medialive.model.Mpeg2GopSizeUnits.UNKNOWN_TO_SDK_VERSION
  }
  case object FRAMES extends zio.aws.medialive.model.Mpeg2GopSizeUnits {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Mpeg2GopSizeUnits =
      software.amazon.awssdk.services.medialive.model.Mpeg2GopSizeUnits.FRAMES
  }
  case object SECONDS extends zio.aws.medialive.model.Mpeg2GopSizeUnits {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Mpeg2GopSizeUnits =
      software.amazon.awssdk.services.medialive.model.Mpeg2GopSizeUnits.SECONDS
  }
}
