package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait Mpeg2ScanType {
  def unwrap: software.amazon.awssdk.services.medialive.model.Mpeg2ScanType
}
object Mpeg2ScanType {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.Mpeg2ScanType
  ): zio.aws.medialive.model.Mpeg2ScanType = value match {
    case software.amazon.awssdk.services.medialive.model.Mpeg2ScanType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.Mpeg2ScanType.INTERLACED =>
      val r = INTERLACED
      r
    case software.amazon.awssdk.services.medialive.model.Mpeg2ScanType.PROGRESSIVE =>
      val r = PROGRESSIVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.Mpeg2ScanType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Mpeg2ScanType =
      software.amazon.awssdk.services.medialive.model.Mpeg2ScanType.UNKNOWN_TO_SDK_VERSION
  }
  case object INTERLACED extends zio.aws.medialive.model.Mpeg2ScanType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Mpeg2ScanType =
      software.amazon.awssdk.services.medialive.model.Mpeg2ScanType.INTERLACED
  }
  case object PROGRESSIVE extends zio.aws.medialive.model.Mpeg2ScanType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Mpeg2ScanType =
      software.amazon.awssdk.services.medialive.model.Mpeg2ScanType.PROGRESSIVE
  }
}
