package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{
  __double,
  __integerMin0Max7,
  __integerMin0,
  __integerMin1
}
import scala.jdk.CollectionConverters._
final case class Mpeg2Settings(
    adaptiveQuantization: Option[
      zio.aws.medialive.model.Mpeg2AdaptiveQuantization
    ] = None,
    afdSignaling: Option[zio.aws.medialive.model.AfdSignaling] = None,
    colorMetadata: Option[zio.aws.medialive.model.Mpeg2ColorMetadata] = None,
    colorSpace: Option[zio.aws.medialive.model.Mpeg2ColorSpace] = None,
    displayAspectRatio: Option[zio.aws.medialive.model.Mpeg2DisplayRatio] =
      None,
    filterSettings: Option[zio.aws.medialive.model.Mpeg2FilterSettings] = None,
    fixedAfd: Option[zio.aws.medialive.model.FixedAfd] = None,
    framerateDenominator: __integerMin1,
    framerateNumerator: __integerMin1,
    gopClosedCadence: Option[__integerMin0] = None,
    gopNumBFrames: Option[__integerMin0Max7] = None,
    gopSize: Option[__double] = None,
    gopSizeUnits: Option[zio.aws.medialive.model.Mpeg2GopSizeUnits] = None,
    scanType: Option[zio.aws.medialive.model.Mpeg2ScanType] = None,
    subgopLength: Option[zio.aws.medialive.model.Mpeg2SubGopLength] = None,
    timecodeInsertion: Option[
      zio.aws.medialive.model.Mpeg2TimecodeInsertionBehavior
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.Mpeg2Settings = {
    import Mpeg2Settings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.Mpeg2Settings
      .builder()
      .optionallyWith(adaptiveQuantization.map(value => value.unwrap))(
        _.adaptiveQuantization
      )
      .optionallyWith(afdSignaling.map(value => value.unwrap))(_.afdSignaling)
      .optionallyWith(colorMetadata.map(value => value.unwrap))(_.colorMetadata)
      .optionallyWith(colorSpace.map(value => value.unwrap))(_.colorSpace)
      .optionallyWith(displayAspectRatio.map(value => value.unwrap))(
        _.displayAspectRatio
      )
      .optionallyWith(filterSettings.map(value => value.buildAwsValue()))(
        _.filterSettings
      )
      .optionallyWith(fixedAfd.map(value => value.unwrap))(_.fixedAfd)
      .framerateDenominator(framerateDenominator: Integer)
      .framerateNumerator(framerateNumerator: Integer)
      .optionallyWith(gopClosedCadence.map(value => value: Integer))(
        _.gopClosedCadence
      )
      .optionallyWith(gopNumBFrames.map(value => value: Integer))(
        _.gopNumBFrames
      )
      .optionallyWith(gopSize.map(value => value: java.lang.Double))(_.gopSize)
      .optionallyWith(gopSizeUnits.map(value => value.unwrap))(_.gopSizeUnits)
      .optionallyWith(scanType.map(value => value.unwrap))(_.scanType)
      .optionallyWith(subgopLength.map(value => value.unwrap))(_.subgopLength)
      .optionallyWith(timecodeInsertion.map(value => value.unwrap))(
        _.timecodeInsertion
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.Mpeg2Settings.ReadOnly =
    zio.aws.medialive.model.Mpeg2Settings.wrap(buildAwsValue())
}
object Mpeg2Settings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.Mpeg2Settings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.Mpeg2Settings =
      zio.aws.medialive.model.Mpeg2Settings(
        adaptiveQuantization.map(value => value),
        afdSignaling.map(value => value),
        colorMetadata.map(value => value),
        colorSpace.map(value => value),
        displayAspectRatio.map(value => value),
        filterSettings.map(value => value.asEditable),
        fixedAfd.map(value => value),
        framerateDenominator,
        framerateNumerator,
        gopClosedCadence.map(value => value),
        gopNumBFrames.map(value => value),
        gopSize.map(value => value),
        gopSizeUnits.map(value => value),
        scanType.map(value => value),
        subgopLength.map(value => value),
        timecodeInsertion.map(value => value)
      )
    def adaptiveQuantization
        : Option[zio.aws.medialive.model.Mpeg2AdaptiveQuantization]
    def afdSignaling: Option[zio.aws.medialive.model.AfdSignaling]
    def colorMetadata: Option[zio.aws.medialive.model.Mpeg2ColorMetadata]
    def colorSpace: Option[zio.aws.medialive.model.Mpeg2ColorSpace]
    def displayAspectRatio: Option[zio.aws.medialive.model.Mpeg2DisplayRatio]
    def filterSettings
        : Option[zio.aws.medialive.model.Mpeg2FilterSettings.ReadOnly]
    def fixedAfd: Option[zio.aws.medialive.model.FixedAfd]
    def framerateDenominator: __integerMin1
    def framerateNumerator: __integerMin1
    def gopClosedCadence: Option[__integerMin0]
    def gopNumBFrames: Option[__integerMin0Max7]
    def gopSize: Option[__double]
    def gopSizeUnits: Option[zio.aws.medialive.model.Mpeg2GopSizeUnits]
    def scanType: Option[zio.aws.medialive.model.Mpeg2ScanType]
    def subgopLength: Option[zio.aws.medialive.model.Mpeg2SubGopLength]
    def timecodeInsertion
        : Option[zio.aws.medialive.model.Mpeg2TimecodeInsertionBehavior]
    def getAdaptiveQuantization: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.Mpeg2AdaptiveQuantization
    ] = AwsError.unwrapOptionField("adaptiveQuantization", adaptiveQuantization)
    def getAfdSignaling
        : ZIO[Any, AwsError, zio.aws.medialive.model.AfdSignaling] =
      AwsError.unwrapOptionField("afdSignaling", afdSignaling)
    def getColorMetadata
        : ZIO[Any, AwsError, zio.aws.medialive.model.Mpeg2ColorMetadata] =
      AwsError.unwrapOptionField("colorMetadata", colorMetadata)
    def getColorSpace
        : ZIO[Any, AwsError, zio.aws.medialive.model.Mpeg2ColorSpace] =
      AwsError.unwrapOptionField("colorSpace", colorSpace)
    def getDisplayAspectRatio
        : ZIO[Any, AwsError, zio.aws.medialive.model.Mpeg2DisplayRatio] =
      AwsError.unwrapOptionField("displayAspectRatio", displayAspectRatio)
    def getFilterSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.Mpeg2FilterSettings.ReadOnly
    ] = AwsError.unwrapOptionField("filterSettings", filterSettings)
    def getFixedAfd: ZIO[Any, AwsError, zio.aws.medialive.model.FixedAfd] =
      AwsError.unwrapOptionField("fixedAfd", fixedAfd)
    def getFramerateDenominator: ZIO[Any, Nothing, __integerMin1] =
      ZIO.succeed(framerateDenominator)
    def getFramerateNumerator: ZIO[Any, Nothing, __integerMin1] =
      ZIO.succeed(framerateNumerator)
    def getGopClosedCadence: ZIO[Any, AwsError, __integerMin0] =
      AwsError.unwrapOptionField("gopClosedCadence", gopClosedCadence)
    def getGopNumBFrames: ZIO[Any, AwsError, __integerMin0Max7] =
      AwsError.unwrapOptionField("gopNumBFrames", gopNumBFrames)
    def getGopSize: ZIO[Any, AwsError, __double] =
      AwsError.unwrapOptionField("gopSize", gopSize)
    def getGopSizeUnits
        : ZIO[Any, AwsError, zio.aws.medialive.model.Mpeg2GopSizeUnits] =
      AwsError.unwrapOptionField("gopSizeUnits", gopSizeUnits)
    def getScanType: ZIO[Any, AwsError, zio.aws.medialive.model.Mpeg2ScanType] =
      AwsError.unwrapOptionField("scanType", scanType)
    def getSubgopLength
        : ZIO[Any, AwsError, zio.aws.medialive.model.Mpeg2SubGopLength] =
      AwsError.unwrapOptionField("subgopLength", subgopLength)
    def getTimecodeInsertion: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.Mpeg2TimecodeInsertionBehavior
    ] = AwsError.unwrapOptionField("timecodeInsertion", timecodeInsertion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.Mpeg2Settings
  ) extends zio.aws.medialive.model.Mpeg2Settings.ReadOnly {
    override val adaptiveQuantization
        : Option[zio.aws.medialive.model.Mpeg2AdaptiveQuantization] = scala
      .Option(impl.adaptiveQuantization())
      .map(value =>
        zio.aws.medialive.model.Mpeg2AdaptiveQuantization.wrap(value)
      )
    override val afdSignaling: Option[zio.aws.medialive.model.AfdSignaling] =
      scala
        .Option(impl.afdSignaling())
        .map(value => zio.aws.medialive.model.AfdSignaling.wrap(value))
    override val colorMetadata
        : Option[zio.aws.medialive.model.Mpeg2ColorMetadata] = scala
      .Option(impl.colorMetadata())
      .map(value => zio.aws.medialive.model.Mpeg2ColorMetadata.wrap(value))
    override val colorSpace: Option[zio.aws.medialive.model.Mpeg2ColorSpace] =
      scala
        .Option(impl.colorSpace())
        .map(value => zio.aws.medialive.model.Mpeg2ColorSpace.wrap(value))
    override val displayAspectRatio
        : Option[zio.aws.medialive.model.Mpeg2DisplayRatio] = scala
      .Option(impl.displayAspectRatio())
      .map(value => zio.aws.medialive.model.Mpeg2DisplayRatio.wrap(value))
    override val filterSettings
        : Option[zio.aws.medialive.model.Mpeg2FilterSettings.ReadOnly] = scala
      .Option(impl.filterSettings())
      .map(value => zio.aws.medialive.model.Mpeg2FilterSettings.wrap(value))
    override val fixedAfd: Option[zio.aws.medialive.model.FixedAfd] = scala
      .Option(impl.fixedAfd())
      .map(value => zio.aws.medialive.model.FixedAfd.wrap(value))
    override val framerateDenominator: __integerMin1 =
      impl.framerateDenominator(): __integerMin1
    override val framerateNumerator: __integerMin1 =
      impl.framerateNumerator(): __integerMin1
    override val gopClosedCadence: Option[__integerMin0] =
      scala.Option(impl.gopClosedCadence()).map(value => value: __integerMin0)
    override val gopNumBFrames: Option[__integerMin0Max7] =
      scala.Option(impl.gopNumBFrames()).map(value => value: __integerMin0Max7)
    override val gopSize: Option[__double] =
      scala.Option(impl.gopSize()).map(value => value: __double)
    override val gopSizeUnits
        : Option[zio.aws.medialive.model.Mpeg2GopSizeUnits] = scala
      .Option(impl.gopSizeUnits())
      .map(value => zio.aws.medialive.model.Mpeg2GopSizeUnits.wrap(value))
    override val scanType: Option[zio.aws.medialive.model.Mpeg2ScanType] = scala
      .Option(impl.scanType())
      .map(value => zio.aws.medialive.model.Mpeg2ScanType.wrap(value))
    override val subgopLength
        : Option[zio.aws.medialive.model.Mpeg2SubGopLength] = scala
      .Option(impl.subgopLength())
      .map(value => zio.aws.medialive.model.Mpeg2SubGopLength.wrap(value))
    override val timecodeInsertion
        : Option[zio.aws.medialive.model.Mpeg2TimecodeInsertionBehavior] = scala
      .Option(impl.timecodeInsertion())
      .map(value =>
        zio.aws.medialive.model.Mpeg2TimecodeInsertionBehavior.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.Mpeg2Settings
  ): zio.aws.medialive.model.Mpeg2Settings.ReadOnly = new Wrapper(impl)
}
