package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait Mpeg2TimecodeInsertionBehavior {
  def unwrap: software.amazon.awssdk.services.medialive.model.Mpeg2TimecodeInsertionBehavior
}
object Mpeg2TimecodeInsertionBehavior {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.Mpeg2TimecodeInsertionBehavior
  ): zio.aws.medialive.model.Mpeg2TimecodeInsertionBehavior = value match {
    case software.amazon.awssdk.services.medialive.model.Mpeg2TimecodeInsertionBehavior.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.Mpeg2TimecodeInsertionBehavior.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.medialive.model.Mpeg2TimecodeInsertionBehavior.GOP_TIMECODE =>
      val r = GOP_TIMECODE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.Mpeg2TimecodeInsertionBehavior {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Mpeg2TimecodeInsertionBehavior =
      software.amazon.awssdk.services.medialive.model.Mpeg2TimecodeInsertionBehavior.UNKNOWN_TO_SDK_VERSION
  }
  case object DISABLED
      extends zio.aws.medialive.model.Mpeg2TimecodeInsertionBehavior {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Mpeg2TimecodeInsertionBehavior =
      software.amazon.awssdk.services.medialive.model.Mpeg2TimecodeInsertionBehavior.DISABLED
  }
  case object GOP_TIMECODE
      extends zio.aws.medialive.model.Mpeg2TimecodeInsertionBehavior {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.Mpeg2TimecodeInsertionBehavior =
      software.amazon.awssdk.services.medialive.model.Mpeg2TimecodeInsertionBehavior.GOP_TIMECODE
  }
}
