package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{
  __integerMin0Max10000,
  __integerMin1,
  __integerMin0,
  __string
}
import scala.jdk.CollectionConverters._
final case class MsSmoothGroupSettings(
    acquisitionPointId: Option[__string] = None,
    audioOnlyTimecodeControl: Option[
      zio.aws.medialive.model.SmoothGroupAudioOnlyTimecodeControl
    ] = None,
    certificateMode: Option[
      zio.aws.medialive.model.SmoothGroupCertificateMode
    ] = None,
    connectionRetryInterval: Option[__integerMin0] = None,
    destination: zio.aws.medialive.model.OutputLocationRef,
    eventId: Option[__string] = None,
    eventIdMode: Option[zio.aws.medialive.model.SmoothGroupEventIdMode] = None,
    eventStopBehavior: Option[
      zio.aws.medialive.model.SmoothGroupEventStopBehavior
    ] = None,
    filecacheDuration: Option[__integerMin0] = None,
    fragmentLength: Option[__integerMin1] = None,
    inputLossAction: Option[
      zio.aws.medialive.model.InputLossActionForMsSmoothOut
    ] = None,
    numRetries: Option[__integerMin0] = None,
    restartDelay: Option[__integerMin0] = None,
    segmentationMode: Option[
      zio.aws.medialive.model.SmoothGroupSegmentationMode
    ] = None,
    sendDelayMs: Option[__integerMin0Max10000] = None,
    sparseTrackType: Option[
      zio.aws.medialive.model.SmoothGroupSparseTrackType
    ] = None,
    streamManifestBehavior: Option[
      zio.aws.medialive.model.SmoothGroupStreamManifestBehavior
    ] = None,
    timestampOffset: Option[__string] = None,
    timestampOffsetMode: Option[
      zio.aws.medialive.model.SmoothGroupTimestampOffsetMode
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.MsSmoothGroupSettings = {
    import MsSmoothGroupSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.MsSmoothGroupSettings
      .builder()
      .optionallyWith(acquisitionPointId.map(value => value: java.lang.String))(
        _.acquisitionPointId
      )
      .optionallyWith(audioOnlyTimecodeControl.map(value => value.unwrap))(
        _.audioOnlyTimecodeControl
      )
      .optionallyWith(certificateMode.map(value => value.unwrap))(
        _.certificateMode
      )
      .optionallyWith(connectionRetryInterval.map(value => value: Integer))(
        _.connectionRetryInterval
      )
      .destination(destination.buildAwsValue())
      .optionallyWith(eventId.map(value => value: java.lang.String))(_.eventId)
      .optionallyWith(eventIdMode.map(value => value.unwrap))(_.eventIdMode)
      .optionallyWith(eventStopBehavior.map(value => value.unwrap))(
        _.eventStopBehavior
      )
      .optionallyWith(filecacheDuration.map(value => value: Integer))(
        _.filecacheDuration
      )
      .optionallyWith(fragmentLength.map(value => value: Integer))(
        _.fragmentLength
      )
      .optionallyWith(inputLossAction.map(value => value.unwrap))(
        _.inputLossAction
      )
      .optionallyWith(numRetries.map(value => value: Integer))(_.numRetries)
      .optionallyWith(restartDelay.map(value => value: Integer))(_.restartDelay)
      .optionallyWith(segmentationMode.map(value => value.unwrap))(
        _.segmentationMode
      )
      .optionallyWith(sendDelayMs.map(value => value: Integer))(_.sendDelayMs)
      .optionallyWith(sparseTrackType.map(value => value.unwrap))(
        _.sparseTrackType
      )
      .optionallyWith(streamManifestBehavior.map(value => value.unwrap))(
        _.streamManifestBehavior
      )
      .optionallyWith(timestampOffset.map(value => value: java.lang.String))(
        _.timestampOffset
      )
      .optionallyWith(timestampOffsetMode.map(value => value.unwrap))(
        _.timestampOffsetMode
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.MsSmoothGroupSettings.ReadOnly =
    zio.aws.medialive.model.MsSmoothGroupSettings.wrap(buildAwsValue())
}
object MsSmoothGroupSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.MsSmoothGroupSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.MsSmoothGroupSettings =
      zio.aws.medialive.model.MsSmoothGroupSettings(
        acquisitionPointId.map(value => value),
        audioOnlyTimecodeControl.map(value => value),
        certificateMode.map(value => value),
        connectionRetryInterval.map(value => value),
        destination.asEditable,
        eventId.map(value => value),
        eventIdMode.map(value => value),
        eventStopBehavior.map(value => value),
        filecacheDuration.map(value => value),
        fragmentLength.map(value => value),
        inputLossAction.map(value => value),
        numRetries.map(value => value),
        restartDelay.map(value => value),
        segmentationMode.map(value => value),
        sendDelayMs.map(value => value),
        sparseTrackType.map(value => value),
        streamManifestBehavior.map(value => value),
        timestampOffset.map(value => value),
        timestampOffsetMode.map(value => value)
      )
    def acquisitionPointId: Option[__string]
    def audioOnlyTimecodeControl
        : Option[zio.aws.medialive.model.SmoothGroupAudioOnlyTimecodeControl]
    def certificateMode
        : Option[zio.aws.medialive.model.SmoothGroupCertificateMode]
    def connectionRetryInterval: Option[__integerMin0]
    def destination: zio.aws.medialive.model.OutputLocationRef.ReadOnly
    def eventId: Option[__string]
    def eventIdMode: Option[zio.aws.medialive.model.SmoothGroupEventIdMode]
    def eventStopBehavior
        : Option[zio.aws.medialive.model.SmoothGroupEventStopBehavior]
    def filecacheDuration: Option[__integerMin0]
    def fragmentLength: Option[__integerMin1]
    def inputLossAction
        : Option[zio.aws.medialive.model.InputLossActionForMsSmoothOut]
    def numRetries: Option[__integerMin0]
    def restartDelay: Option[__integerMin0]
    def segmentationMode
        : Option[zio.aws.medialive.model.SmoothGroupSegmentationMode]
    def sendDelayMs: Option[__integerMin0Max10000]
    def sparseTrackType
        : Option[zio.aws.medialive.model.SmoothGroupSparseTrackType]
    def streamManifestBehavior
        : Option[zio.aws.medialive.model.SmoothGroupStreamManifestBehavior]
    def timestampOffset: Option[__string]
    def timestampOffsetMode
        : Option[zio.aws.medialive.model.SmoothGroupTimestampOffsetMode]
    def getAcquisitionPointId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("acquisitionPointId", acquisitionPointId)
    def getAudioOnlyTimecodeControl: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.SmoothGroupAudioOnlyTimecodeControl
    ] = AwsError.unwrapOptionField(
      "audioOnlyTimecodeControl",
      audioOnlyTimecodeControl
    )
    def getCertificateMode: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.SmoothGroupCertificateMode
    ] = AwsError.unwrapOptionField("certificateMode", certificateMode)
    def getConnectionRetryInterval: ZIO[Any, AwsError, __integerMin0] = AwsError
      .unwrapOptionField("connectionRetryInterval", connectionRetryInterval)
    def getDestination: ZIO[
      Any,
      Nothing,
      zio.aws.medialive.model.OutputLocationRef.ReadOnly
    ] = ZIO.succeed(destination)
    def getEventId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("eventId", eventId)
    def getEventIdMode
        : ZIO[Any, AwsError, zio.aws.medialive.model.SmoothGroupEventIdMode] =
      AwsError.unwrapOptionField("eventIdMode", eventIdMode)
    def getEventStopBehavior: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.SmoothGroupEventStopBehavior
    ] = AwsError.unwrapOptionField("eventStopBehavior", eventStopBehavior)
    def getFilecacheDuration: ZIO[Any, AwsError, __integerMin0] =
      AwsError.unwrapOptionField("filecacheDuration", filecacheDuration)
    def getFragmentLength: ZIO[Any, AwsError, __integerMin1] =
      AwsError.unwrapOptionField("fragmentLength", fragmentLength)
    def getInputLossAction: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.InputLossActionForMsSmoothOut
    ] = AwsError.unwrapOptionField("inputLossAction", inputLossAction)
    def getNumRetries: ZIO[Any, AwsError, __integerMin0] =
      AwsError.unwrapOptionField("numRetries", numRetries)
    def getRestartDelay: ZIO[Any, AwsError, __integerMin0] =
      AwsError.unwrapOptionField("restartDelay", restartDelay)
    def getSegmentationMode: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.SmoothGroupSegmentationMode
    ] = AwsError.unwrapOptionField("segmentationMode", segmentationMode)
    def getSendDelayMs: ZIO[Any, AwsError, __integerMin0Max10000] =
      AwsError.unwrapOptionField("sendDelayMs", sendDelayMs)
    def getSparseTrackType: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.SmoothGroupSparseTrackType
    ] = AwsError.unwrapOptionField("sparseTrackType", sparseTrackType)
    def getStreamManifestBehavior: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.SmoothGroupStreamManifestBehavior
    ] = AwsError.unwrapOptionField(
      "streamManifestBehavior",
      streamManifestBehavior
    )
    def getTimestampOffset: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("timestampOffset", timestampOffset)
    def getTimestampOffsetMode: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.SmoothGroupTimestampOffsetMode
    ] = AwsError.unwrapOptionField("timestampOffsetMode", timestampOffsetMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.MsSmoothGroupSettings
  ) extends zio.aws.medialive.model.MsSmoothGroupSettings.ReadOnly {
    override val acquisitionPointId: Option[__string] =
      scala.Option(impl.acquisitionPointId()).map(value => value: __string)
    override val audioOnlyTimecodeControl
        : Option[zio.aws.medialive.model.SmoothGroupAudioOnlyTimecodeControl] =
      scala
        .Option(impl.audioOnlyTimecodeControl())
        .map(value =>
          zio.aws.medialive.model.SmoothGroupAudioOnlyTimecodeControl
            .wrap(value)
        )
    override val certificateMode
        : Option[zio.aws.medialive.model.SmoothGroupCertificateMode] = scala
      .Option(impl.certificateMode())
      .map(value =>
        zio.aws.medialive.model.SmoothGroupCertificateMode.wrap(value)
      )
    override val connectionRetryInterval: Option[__integerMin0] = scala
      .Option(impl.connectionRetryInterval())
      .map(value => value: __integerMin0)
    override val destination
        : zio.aws.medialive.model.OutputLocationRef.ReadOnly =
      zio.aws.medialive.model.OutputLocationRef.wrap(impl.destination())
    override val eventId: Option[__string] =
      scala.Option(impl.eventId()).map(value => value: __string)
    override val eventIdMode
        : Option[zio.aws.medialive.model.SmoothGroupEventIdMode] = scala
      .Option(impl.eventIdMode())
      .map(value => zio.aws.medialive.model.SmoothGroupEventIdMode.wrap(value))
    override val eventStopBehavior
        : Option[zio.aws.medialive.model.SmoothGroupEventStopBehavior] = scala
      .Option(impl.eventStopBehavior())
      .map(value =>
        zio.aws.medialive.model.SmoothGroupEventStopBehavior.wrap(value)
      )
    override val filecacheDuration: Option[__integerMin0] =
      scala.Option(impl.filecacheDuration()).map(value => value: __integerMin0)
    override val fragmentLength: Option[__integerMin1] =
      scala.Option(impl.fragmentLength()).map(value => value: __integerMin1)
    override val inputLossAction
        : Option[zio.aws.medialive.model.InputLossActionForMsSmoothOut] = scala
      .Option(impl.inputLossAction())
      .map(value =>
        zio.aws.medialive.model.InputLossActionForMsSmoothOut.wrap(value)
      )
    override val numRetries: Option[__integerMin0] =
      scala.Option(impl.numRetries()).map(value => value: __integerMin0)
    override val restartDelay: Option[__integerMin0] =
      scala.Option(impl.restartDelay()).map(value => value: __integerMin0)
    override val segmentationMode
        : Option[zio.aws.medialive.model.SmoothGroupSegmentationMode] = scala
      .Option(impl.segmentationMode())
      .map(value =>
        zio.aws.medialive.model.SmoothGroupSegmentationMode.wrap(value)
      )
    override val sendDelayMs: Option[__integerMin0Max10000] = scala
      .Option(impl.sendDelayMs())
      .map(value => value: __integerMin0Max10000)
    override val sparseTrackType
        : Option[zio.aws.medialive.model.SmoothGroupSparseTrackType] = scala
      .Option(impl.sparseTrackType())
      .map(value =>
        zio.aws.medialive.model.SmoothGroupSparseTrackType.wrap(value)
      )
    override val streamManifestBehavior
        : Option[zio.aws.medialive.model.SmoothGroupStreamManifestBehavior] =
      scala
        .Option(impl.streamManifestBehavior())
        .map(value =>
          zio.aws.medialive.model.SmoothGroupStreamManifestBehavior.wrap(value)
        )
    override val timestampOffset: Option[__string] =
      scala.Option(impl.timestampOffset()).map(value => value: __string)
    override val timestampOffsetMode
        : Option[zio.aws.medialive.model.SmoothGroupTimestampOffsetMode] = scala
      .Option(impl.timestampOffsetMode())
      .map(value =>
        zio.aws.medialive.model.SmoothGroupTimestampOffsetMode.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.MsSmoothGroupSettings
  ): zio.aws.medialive.model.MsSmoothGroupSettings.ReadOnly = new Wrapper(impl)
}
