package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait MsSmoothH265PackagingType {
  def unwrap: software.amazon.awssdk.services.medialive.model.MsSmoothH265PackagingType
}
object MsSmoothH265PackagingType {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.MsSmoothH265PackagingType
  ): zio.aws.medialive.model.MsSmoothH265PackagingType = value match {
    case software.amazon.awssdk.services.medialive.model.MsSmoothH265PackagingType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.MsSmoothH265PackagingType.HEV1 =>
      val r = HEV1
      r
    case software.amazon.awssdk.services.medialive.model.MsSmoothH265PackagingType.HVC1 =>
      val r = HVC1
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.MsSmoothH265PackagingType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.MsSmoothH265PackagingType =
      software.amazon.awssdk.services.medialive.model.MsSmoothH265PackagingType.UNKNOWN_TO_SDK_VERSION
  }
  case object HEV1 extends zio.aws.medialive.model.MsSmoothH265PackagingType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.MsSmoothH265PackagingType =
      software.amazon.awssdk.services.medialive.model.MsSmoothH265PackagingType.HEV1
  }
  case object HVC1 extends zio.aws.medialive.model.MsSmoothH265PackagingType {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.MsSmoothH265PackagingType =
      software.amazon.awssdk.services.medialive.model.MsSmoothH265PackagingType.HVC1
  }
}
