package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class MsSmoothOutputSettings(
    h265PackagingType: Option[
      zio.aws.medialive.model.MsSmoothH265PackagingType
    ] = None,
    nameModifier: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.MsSmoothOutputSettings = {
    import MsSmoothOutputSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.MsSmoothOutputSettings
      .builder()
      .optionallyWith(h265PackagingType.map(value => value.unwrap))(
        _.h265PackagingType
      )
      .optionallyWith(nameModifier.map(value => value: java.lang.String))(
        _.nameModifier
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.MsSmoothOutputSettings.ReadOnly =
    zio.aws.medialive.model.MsSmoothOutputSettings.wrap(buildAwsValue())
}
object MsSmoothOutputSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.MsSmoothOutputSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.MsSmoothOutputSettings =
      zio.aws.medialive.model.MsSmoothOutputSettings(
        h265PackagingType.map(value => value),
        nameModifier.map(value => value)
      )
    def h265PackagingType
        : Option[zio.aws.medialive.model.MsSmoothH265PackagingType]
    def nameModifier: Option[__string]
    def getH265PackagingType: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.MsSmoothH265PackagingType
    ] = AwsError.unwrapOptionField("h265PackagingType", h265PackagingType)
    def getNameModifier: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nameModifier", nameModifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.MsSmoothOutputSettings
  ) extends zio.aws.medialive.model.MsSmoothOutputSettings.ReadOnly {
    override val h265PackagingType
        : Option[zio.aws.medialive.model.MsSmoothH265PackagingType] = scala
      .Option(impl.h265PackagingType())
      .map(value =>
        zio.aws.medialive.model.MsSmoothH265PackagingType.wrap(value)
      )
    override val nameModifier: Option[__string] =
      scala.Option(impl.nameModifier()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.MsSmoothOutputSettings
  ): zio.aws.medialive.model.MsSmoothOutputSettings.ReadOnly = new Wrapper(impl)
}
