package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__stringMin1
import scala.jdk.CollectionConverters._
final case class MultiplexMediaConnectOutputDestinationSettings(
    entitlementArn: Option[__stringMin1] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.MultiplexMediaConnectOutputDestinationSettings = {
    import MultiplexMediaConnectOutputDestinationSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.MultiplexMediaConnectOutputDestinationSettings
      .builder()
      .optionallyWith(entitlementArn.map(value => value: java.lang.String))(
        _.entitlementArn
      )
      .build()
  }
  def asReadOnly
      : zio.aws.medialive.model.MultiplexMediaConnectOutputDestinationSettings.ReadOnly =
    zio.aws.medialive.model.MultiplexMediaConnectOutputDestinationSettings
      .wrap(buildAwsValue())
}
object MultiplexMediaConnectOutputDestinationSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.MultiplexMediaConnectOutputDestinationSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.medialive.model.MultiplexMediaConnectOutputDestinationSettings =
      zio.aws.medialive.model.MultiplexMediaConnectOutputDestinationSettings(
        entitlementArn.map(value => value)
      )
    def entitlementArn: Option[__stringMin1]
    def getEntitlementArn: ZIO[Any, AwsError, __stringMin1] =
      AwsError.unwrapOptionField("entitlementArn", entitlementArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.MultiplexMediaConnectOutputDestinationSettings
  ) extends zio.aws.medialive.model.MultiplexMediaConnectOutputDestinationSettings.ReadOnly {
    override val entitlementArn: Option[__stringMin1] =
      scala.Option(impl.entitlementArn()).map(value => value: __stringMin1)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.MultiplexMediaConnectOutputDestinationSettings
  ): zio.aws.medialive.model.MultiplexMediaConnectOutputDestinationSettings.ReadOnly =
    new Wrapper(impl)
}
