package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MultiplexOutputDestination(
    mediaConnectSettings: Option[
      zio.aws.medialive.model.MultiplexMediaConnectOutputDestinationSettings
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.MultiplexOutputDestination = {
    import MultiplexOutputDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.MultiplexOutputDestination
      .builder()
      .optionallyWith(mediaConnectSettings.map(value => value.buildAwsValue()))(
        _.mediaConnectSettings
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.MultiplexOutputDestination.ReadOnly =
    zio.aws.medialive.model.MultiplexOutputDestination.wrap(buildAwsValue())
}
object MultiplexOutputDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.MultiplexOutputDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.MultiplexOutputDestination =
      zio.aws.medialive.model.MultiplexOutputDestination(
        mediaConnectSettings.map(value => value.asEditable)
      )
    def mediaConnectSettings: Option[
      zio.aws.medialive.model.MultiplexMediaConnectOutputDestinationSettings.ReadOnly
    ]
    def getMediaConnectSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.MultiplexMediaConnectOutputDestinationSettings.ReadOnly
    ] = AwsError.unwrapOptionField("mediaConnectSettings", mediaConnectSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.MultiplexOutputDestination
  ) extends zio.aws.medialive.model.MultiplexOutputDestination.ReadOnly {
    override val mediaConnectSettings: Option[
      zio.aws.medialive.model.MultiplexMediaConnectOutputDestinationSettings.ReadOnly
    ] = scala
      .Option(impl.mediaConnectSettings())
      .map(value =>
        zio.aws.medialive.model.MultiplexMediaConnectOutputDestinationSettings
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.MultiplexOutputDestination
  ): zio.aws.medialive.model.MultiplexOutputDestination.ReadOnly = new Wrapper(
    impl
  )
}
