package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class MultiplexOutputSettings(
    destination: zio.aws.medialive.model.OutputLocationRef
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.MultiplexOutputSettings = {
    import MultiplexOutputSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.MultiplexOutputSettings
      .builder()
      .destination(destination.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.MultiplexOutputSettings.ReadOnly =
    zio.aws.medialive.model.MultiplexOutputSettings.wrap(buildAwsValue())
}
object MultiplexOutputSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.MultiplexOutputSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.MultiplexOutputSettings =
      zio.aws.medialive.model.MultiplexOutputSettings(destination.asEditable)
    def destination: zio.aws.medialive.model.OutputLocationRef.ReadOnly
    def getDestination: ZIO[
      Any,
      Nothing,
      zio.aws.medialive.model.OutputLocationRef.ReadOnly
    ] = ZIO.succeed(destination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.MultiplexOutputSettings
  ) extends zio.aws.medialive.model.MultiplexOutputSettings.ReadOnly {
    override val destination
        : zio.aws.medialive.model.OutputLocationRef.ReadOnly =
      zio.aws.medialive.model.OutputLocationRef.wrap(impl.destination())
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.MultiplexOutputSettings
  ): zio.aws.medialive.model.MultiplexOutputSettings.ReadOnly = new Wrapper(
    impl
  )
}
