package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class MultiplexProgram(
    channelId: Option[__string] = None,
    multiplexProgramSettings: Option[
      zio.aws.medialive.model.MultiplexProgramSettings
    ] = None,
    packetIdentifiersMap: Option[
      zio.aws.medialive.model.MultiplexProgramPacketIdentifiersMap
    ] = None,
    pipelineDetails: Option[
      Iterable[zio.aws.medialive.model.MultiplexProgramPipelineDetail]
    ] = None,
    programName: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.MultiplexProgram = {
    import MultiplexProgram.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.MultiplexProgram
      .builder()
      .optionallyWith(channelId.map(value => value: java.lang.String))(
        _.channelId
      )
      .optionallyWith(
        multiplexProgramSettings.map(value => value.buildAwsValue())
      )(_.multiplexProgramSettings)
      .optionallyWith(packetIdentifiersMap.map(value => value.buildAwsValue()))(
        _.packetIdentifiersMap
      )
      .optionallyWith(
        pipelineDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pipelineDetails)
      .optionallyWith(programName.map(value => value: java.lang.String))(
        _.programName
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.MultiplexProgram.ReadOnly =
    zio.aws.medialive.model.MultiplexProgram.wrap(buildAwsValue())
}
object MultiplexProgram {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.MultiplexProgram
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.MultiplexProgram =
      zio.aws.medialive.model.MultiplexProgram(
        channelId.map(value => value),
        multiplexProgramSettings.map(value => value.asEditable),
        packetIdentifiersMap.map(value => value.asEditable),
        pipelineDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        programName.map(value => value)
      )
    def channelId: Option[__string]
    def multiplexProgramSettings
        : Option[zio.aws.medialive.model.MultiplexProgramSettings.ReadOnly]
    def packetIdentifiersMap: Option[
      zio.aws.medialive.model.MultiplexProgramPacketIdentifiersMap.ReadOnly
    ]
    def pipelineDetails: Option[
      List[zio.aws.medialive.model.MultiplexProgramPipelineDetail.ReadOnly]
    ]
    def programName: Option[__string]
    def getChannelId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("channelId", channelId)
    def getMultiplexProgramSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.MultiplexProgramSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "multiplexProgramSettings",
      multiplexProgramSettings
    )
    def getPacketIdentifiersMap: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.MultiplexProgramPacketIdentifiersMap.ReadOnly
    ] = AwsError.unwrapOptionField("packetIdentifiersMap", packetIdentifiersMap)
    def getPipelineDetails: ZIO[Any, AwsError, List[
      zio.aws.medialive.model.MultiplexProgramPipelineDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("pipelineDetails", pipelineDetails)
    def getProgramName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("programName", programName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.MultiplexProgram
  ) extends zio.aws.medialive.model.MultiplexProgram.ReadOnly {
    override val channelId: Option[__string] =
      scala.Option(impl.channelId()).map(value => value: __string)
    override val multiplexProgramSettings
        : Option[zio.aws.medialive.model.MultiplexProgramSettings.ReadOnly] =
      scala
        .Option(impl.multiplexProgramSettings())
        .map(value =>
          zio.aws.medialive.model.MultiplexProgramSettings.wrap(value)
        )
    override val packetIdentifiersMap: Option[
      zio.aws.medialive.model.MultiplexProgramPacketIdentifiersMap.ReadOnly
    ] = scala
      .Option(impl.packetIdentifiersMap())
      .map(value =>
        zio.aws.medialive.model.MultiplexProgramPacketIdentifiersMap.wrap(value)
      )
    override val pipelineDetails: Option[
      List[zio.aws.medialive.model.MultiplexProgramPipelineDetail.ReadOnly]
    ] = scala
      .Option(impl.pipelineDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.medialive.model.MultiplexProgramPipelineDetail.wrap(item)
        }.toList
      )
    override val programName: Option[__string] =
      scala.Option(impl.programName()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.MultiplexProgram
  ): zio.aws.medialive.model.MultiplexProgram.ReadOnly = new Wrapper(impl)
}
