package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__stringMin1
import scala.jdk.CollectionConverters._
final case class MultiplexProgramChannelDestinationSettings(
    multiplexId: Option[__stringMin1] = None,
    programName: Option[__stringMin1] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.MultiplexProgramChannelDestinationSettings = {
    import MultiplexProgramChannelDestinationSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.MultiplexProgramChannelDestinationSettings
      .builder()
      .optionallyWith(multiplexId.map(value => value: java.lang.String))(
        _.multiplexId
      )
      .optionallyWith(programName.map(value => value: java.lang.String))(
        _.programName
      )
      .build()
  }
  def asReadOnly
      : zio.aws.medialive.model.MultiplexProgramChannelDestinationSettings.ReadOnly =
    zio.aws.medialive.model.MultiplexProgramChannelDestinationSettings
      .wrap(buildAwsValue())
}
object MultiplexProgramChannelDestinationSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.MultiplexProgramChannelDestinationSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.medialive.model.MultiplexProgramChannelDestinationSettings =
      zio.aws.medialive.model.MultiplexProgramChannelDestinationSettings(
        multiplexId.map(value => value),
        programName.map(value => value)
      )
    def multiplexId: Option[__stringMin1]
    def programName: Option[__stringMin1]
    def getMultiplexId: ZIO[Any, AwsError, __stringMin1] =
      AwsError.unwrapOptionField("multiplexId", multiplexId)
    def getProgramName: ZIO[Any, AwsError, __stringMin1] =
      AwsError.unwrapOptionField("programName", programName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.MultiplexProgramChannelDestinationSettings
  ) extends zio.aws.medialive.model.MultiplexProgramChannelDestinationSettings.ReadOnly {
    override val multiplexId: Option[__stringMin1] =
      scala.Option(impl.multiplexId()).map(value => value: __stringMin1)
    override val programName: Option[__stringMin1] =
      scala.Option(impl.programName()).map(value => value: __stringMin1)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.MultiplexProgramChannelDestinationSettings
  ): zio.aws.medialive.model.MultiplexProgramChannelDestinationSettings.ReadOnly =
    new Wrapper(impl)
}
