package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__integer
import scala.jdk.CollectionConverters._
final case class MultiplexProgramPacketIdentifiersMap(
    audioPids: Option[Iterable[__integer]] = None,
    dvbSubPids: Option[Iterable[__integer]] = None,
    dvbTeletextPid: Option[__integer] = None,
    etvPlatformPid: Option[__integer] = None,
    etvSignalPid: Option[__integer] = None,
    klvDataPids: Option[Iterable[__integer]] = None,
    pcrPid: Option[__integer] = None,
    pmtPid: Option[__integer] = None,
    privateMetadataPid: Option[__integer] = None,
    scte27Pids: Option[Iterable[__integer]] = None,
    scte35Pid: Option[__integer] = None,
    timedMetadataPid: Option[__integer] = None,
    videoPid: Option[__integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.MultiplexProgramPacketIdentifiersMap = {
    import MultiplexProgramPacketIdentifiersMap.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.MultiplexProgramPacketIdentifiersMap
      .builder()
      .optionallyWith(
        audioPids.map(value =>
          value.map { item =>
            item: Integer
          }.asJavaCollection
        )
      )(_.audioPids)
      .optionallyWith(
        dvbSubPids.map(value =>
          value.map { item =>
            item: Integer
          }.asJavaCollection
        )
      )(_.dvbSubPids)
      .optionallyWith(dvbTeletextPid.map(value => value: Integer))(
        _.dvbTeletextPid
      )
      .optionallyWith(etvPlatformPid.map(value => value: Integer))(
        _.etvPlatformPid
      )
      .optionallyWith(etvSignalPid.map(value => value: Integer))(_.etvSignalPid)
      .optionallyWith(
        klvDataPids.map(value =>
          value.map { item =>
            item: Integer
          }.asJavaCollection
        )
      )(_.klvDataPids)
      .optionallyWith(pcrPid.map(value => value: Integer))(_.pcrPid)
      .optionallyWith(pmtPid.map(value => value: Integer))(_.pmtPid)
      .optionallyWith(privateMetadataPid.map(value => value: Integer))(
        _.privateMetadataPid
      )
      .optionallyWith(
        scte27Pids.map(value =>
          value.map { item =>
            item: Integer
          }.asJavaCollection
        )
      )(_.scte27Pids)
      .optionallyWith(scte35Pid.map(value => value: Integer))(_.scte35Pid)
      .optionallyWith(timedMetadataPid.map(value => value: Integer))(
        _.timedMetadataPid
      )
      .optionallyWith(videoPid.map(value => value: Integer))(_.videoPid)
      .build()
  }
  def asReadOnly
      : zio.aws.medialive.model.MultiplexProgramPacketIdentifiersMap.ReadOnly =
    zio.aws.medialive.model.MultiplexProgramPacketIdentifiersMap
      .wrap(buildAwsValue())
}
object MultiplexProgramPacketIdentifiersMap {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.MultiplexProgramPacketIdentifiersMap
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.medialive.model.MultiplexProgramPacketIdentifiersMap =
      zio.aws.medialive.model.MultiplexProgramPacketIdentifiersMap(
        audioPids.map(value => value),
        dvbSubPids.map(value => value),
        dvbTeletextPid.map(value => value),
        etvPlatformPid.map(value => value),
        etvSignalPid.map(value => value),
        klvDataPids.map(value => value),
        pcrPid.map(value => value),
        pmtPid.map(value => value),
        privateMetadataPid.map(value => value),
        scte27Pids.map(value => value),
        scte35Pid.map(value => value),
        timedMetadataPid.map(value => value),
        videoPid.map(value => value)
      )
    def audioPids: Option[List[__integer]]
    def dvbSubPids: Option[List[__integer]]
    def dvbTeletextPid: Option[__integer]
    def etvPlatformPid: Option[__integer]
    def etvSignalPid: Option[__integer]
    def klvDataPids: Option[List[__integer]]
    def pcrPid: Option[__integer]
    def pmtPid: Option[__integer]
    def privateMetadataPid: Option[__integer]
    def scte27Pids: Option[List[__integer]]
    def scte35Pid: Option[__integer]
    def timedMetadataPid: Option[__integer]
    def videoPid: Option[__integer]
    def getAudioPids: ZIO[Any, AwsError, List[__integer]] =
      AwsError.unwrapOptionField("audioPids", audioPids)
    def getDvbSubPids: ZIO[Any, AwsError, List[__integer]] =
      AwsError.unwrapOptionField("dvbSubPids", dvbSubPids)
    def getDvbTeletextPid: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("dvbTeletextPid", dvbTeletextPid)
    def getEtvPlatformPid: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("etvPlatformPid", etvPlatformPid)
    def getEtvSignalPid: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("etvSignalPid", etvSignalPid)
    def getKlvDataPids: ZIO[Any, AwsError, List[__integer]] =
      AwsError.unwrapOptionField("klvDataPids", klvDataPids)
    def getPcrPid: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("pcrPid", pcrPid)
    def getPmtPid: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("pmtPid", pmtPid)
    def getPrivateMetadataPid: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("privateMetadataPid", privateMetadataPid)
    def getScte27Pids: ZIO[Any, AwsError, List[__integer]] =
      AwsError.unwrapOptionField("scte27Pids", scte27Pids)
    def getScte35Pid: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("scte35Pid", scte35Pid)
    def getTimedMetadataPid: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("timedMetadataPid", timedMetadataPid)
    def getVideoPid: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("videoPid", videoPid)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.MultiplexProgramPacketIdentifiersMap
  ) extends zio.aws.medialive.model.MultiplexProgramPacketIdentifiersMap.ReadOnly {
    override val audioPids: Option[List[__integer]] = scala
      .Option(impl.audioPids())
      .map(value =>
        value.asScala.map { item =>
          item: __integer
        }.toList
      )
    override val dvbSubPids: Option[List[__integer]] = scala
      .Option(impl.dvbSubPids())
      .map(value =>
        value.asScala.map { item =>
          item: __integer
        }.toList
      )
    override val dvbTeletextPid: Option[__integer] =
      scala.Option(impl.dvbTeletextPid()).map(value => value: __integer)
    override val etvPlatformPid: Option[__integer] =
      scala.Option(impl.etvPlatformPid()).map(value => value: __integer)
    override val etvSignalPid: Option[__integer] =
      scala.Option(impl.etvSignalPid()).map(value => value: __integer)
    override val klvDataPids: Option[List[__integer]] = scala
      .Option(impl.klvDataPids())
      .map(value =>
        value.asScala.map { item =>
          item: __integer
        }.toList
      )
    override val pcrPid: Option[__integer] =
      scala.Option(impl.pcrPid()).map(value => value: __integer)
    override val pmtPid: Option[__integer] =
      scala.Option(impl.pmtPid()).map(value => value: __integer)
    override val privateMetadataPid: Option[__integer] =
      scala.Option(impl.privateMetadataPid()).map(value => value: __integer)
    override val scte27Pids: Option[List[__integer]] = scala
      .Option(impl.scte27Pids())
      .map(value =>
        value.asScala.map { item =>
          item: __integer
        }.toList
      )
    override val scte35Pid: Option[__integer] =
      scala.Option(impl.scte35Pid()).map(value => value: __integer)
    override val timedMetadataPid: Option[__integer] =
      scala.Option(impl.timedMetadataPid()).map(value => value: __integer)
    override val videoPid: Option[__integer] =
      scala.Option(impl.videoPid()).map(value => value: __integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.MultiplexProgramPacketIdentifiersMap
  ): zio.aws.medialive.model.MultiplexProgramPacketIdentifiersMap.ReadOnly =
    new Wrapper(impl)
}
