package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class MultiplexProgramPipelineDetail(
    activeChannelPipeline: Option[__string] = None,
    pipelineId: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.MultiplexProgramPipelineDetail = {
    import MultiplexProgramPipelineDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.MultiplexProgramPipelineDetail
      .builder()
      .optionallyWith(
        activeChannelPipeline.map(value => value: java.lang.String)
      )(_.activeChannelPipeline)
      .optionallyWith(pipelineId.map(value => value: java.lang.String))(
        _.pipelineId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.medialive.model.MultiplexProgramPipelineDetail.ReadOnly =
    zio.aws.medialive.model.MultiplexProgramPipelineDetail.wrap(buildAwsValue())
}
object MultiplexProgramPipelineDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.MultiplexProgramPipelineDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.MultiplexProgramPipelineDetail =
      zio.aws.medialive.model.MultiplexProgramPipelineDetail(
        activeChannelPipeline.map(value => value),
        pipelineId.map(value => value)
      )
    def activeChannelPipeline: Option[__string]
    def pipelineId: Option[__string]
    def getActiveChannelPipeline: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("activeChannelPipeline", activeChannelPipeline)
    def getPipelineId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("pipelineId", pipelineId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.MultiplexProgramPipelineDetail
  ) extends zio.aws.medialive.model.MultiplexProgramPipelineDetail.ReadOnly {
    override val activeChannelPipeline: Option[__string] =
      scala.Option(impl.activeChannelPipeline()).map(value => value: __string)
    override val pipelineId: Option[__string] =
      scala.Option(impl.pipelineId()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.MultiplexProgramPipelineDetail
  ): zio.aws.medialive.model.MultiplexProgramPipelineDetail.ReadOnly =
    new Wrapper(impl)
}
