package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.medialive.model.primitives.__stringMax256
import scala.jdk.CollectionConverters._
final case class MultiplexProgramServiceDescriptor(
    providerName: __stringMax256,
    serviceName: __stringMax256
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.MultiplexProgramServiceDescriptor = {
    import MultiplexProgramServiceDescriptor.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.MultiplexProgramServiceDescriptor
      .builder()
      .providerName(providerName: java.lang.String)
      .serviceName(serviceName: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.medialive.model.MultiplexProgramServiceDescriptor.ReadOnly =
    zio.aws.medialive.model.MultiplexProgramServiceDescriptor
      .wrap(buildAwsValue())
}
object MultiplexProgramServiceDescriptor {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.MultiplexProgramServiceDescriptor
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.MultiplexProgramServiceDescriptor =
      zio.aws.medialive.model
        .MultiplexProgramServiceDescriptor(providerName, serviceName)
    def providerName: __stringMax256
    def serviceName: __stringMax256
    def getProviderName: ZIO[Any, Nothing, __stringMax256] =
      ZIO.succeed(providerName)
    def getServiceName: ZIO[Any, Nothing, __stringMax256] =
      ZIO.succeed(serviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.MultiplexProgramServiceDescriptor
  ) extends zio.aws.medialive.model.MultiplexProgramServiceDescriptor.ReadOnly {
    override val providerName: __stringMax256 =
      impl.providerName(): __stringMax256
    override val serviceName: __stringMax256 =
      impl.serviceName(): __stringMax256
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.MultiplexProgramServiceDescriptor
  ): zio.aws.medialive.model.MultiplexProgramServiceDescriptor.ReadOnly =
    new Wrapper(impl)
}
