package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__integerMin0Max65535
import scala.jdk.CollectionConverters._
final case class MultiplexProgramSettings(
    preferredChannelPipeline: Option[
      zio.aws.medialive.model.PreferredChannelPipeline
    ] = None,
    programNumber: __integerMin0Max65535,
    serviceDescriptor: Option[
      zio.aws.medialive.model.MultiplexProgramServiceDescriptor
    ] = None,
    videoSettings: Option[zio.aws.medialive.model.MultiplexVideoSettings] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.MultiplexProgramSettings = {
    import MultiplexProgramSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.MultiplexProgramSettings
      .builder()
      .optionallyWith(preferredChannelPipeline.map(value => value.unwrap))(
        _.preferredChannelPipeline
      )
      .programNumber(programNumber: Integer)
      .optionallyWith(serviceDescriptor.map(value => value.buildAwsValue()))(
        _.serviceDescriptor
      )
      .optionallyWith(videoSettings.map(value => value.buildAwsValue()))(
        _.videoSettings
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.MultiplexProgramSettings.ReadOnly =
    zio.aws.medialive.model.MultiplexProgramSettings.wrap(buildAwsValue())
}
object MultiplexProgramSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.MultiplexProgramSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.MultiplexProgramSettings =
      zio.aws.medialive.model.MultiplexProgramSettings(
        preferredChannelPipeline.map(value => value),
        programNumber,
        serviceDescriptor.map(value => value.asEditable),
        videoSettings.map(value => value.asEditable)
      )
    def preferredChannelPipeline
        : Option[zio.aws.medialive.model.PreferredChannelPipeline]
    def programNumber: __integerMin0Max65535
    def serviceDescriptor: Option[
      zio.aws.medialive.model.MultiplexProgramServiceDescriptor.ReadOnly
    ]
    def videoSettings
        : Option[zio.aws.medialive.model.MultiplexVideoSettings.ReadOnly]
    def getPreferredChannelPipeline
        : ZIO[Any, AwsError, zio.aws.medialive.model.PreferredChannelPipeline] =
      AwsError.unwrapOptionField(
        "preferredChannelPipeline",
        preferredChannelPipeline
      )
    def getProgramNumber: ZIO[Any, Nothing, __integerMin0Max65535] =
      ZIO.succeed(programNumber)
    def getServiceDescriptor: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.MultiplexProgramServiceDescriptor.ReadOnly
    ] = AwsError.unwrapOptionField("serviceDescriptor", serviceDescriptor)
    def getVideoSettings: ZIO[
      Any,
      AwsError,
      zio.aws.medialive.model.MultiplexVideoSettings.ReadOnly
    ] = AwsError.unwrapOptionField("videoSettings", videoSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.MultiplexProgramSettings
  ) extends zio.aws.medialive.model.MultiplexProgramSettings.ReadOnly {
    override val preferredChannelPipeline
        : Option[zio.aws.medialive.model.PreferredChannelPipeline] = scala
      .Option(impl.preferredChannelPipeline())
      .map(value =>
        zio.aws.medialive.model.PreferredChannelPipeline.wrap(value)
      )
    override val programNumber: __integerMin0Max65535 =
      impl.programNumber(): __integerMin0Max65535
    override val serviceDescriptor: Option[
      zio.aws.medialive.model.MultiplexProgramServiceDescriptor.ReadOnly
    ] = scala
      .Option(impl.serviceDescriptor())
      .map(value =>
        zio.aws.medialive.model.MultiplexProgramServiceDescriptor.wrap(value)
      )
    override val videoSettings
        : Option[zio.aws.medialive.model.MultiplexVideoSettings.ReadOnly] =
      scala
        .Option(impl.videoSettings())
        .map(value =>
          zio.aws.medialive.model.MultiplexVideoSettings.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.MultiplexProgramSettings
  ): zio.aws.medialive.model.MultiplexProgramSettings.ReadOnly = new Wrapper(
    impl
  )
}
