package zio.aws.medialive.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class MultiplexProgramSummary(
    channelId: Option[__string] = None,
    programName: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.MultiplexProgramSummary = {
    import MultiplexProgramSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.MultiplexProgramSummary
      .builder()
      .optionallyWith(channelId.map(value => value: java.lang.String))(
        _.channelId
      )
      .optionallyWith(programName.map(value => value: java.lang.String))(
        _.programName
      )
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.MultiplexProgramSummary.ReadOnly =
    zio.aws.medialive.model.MultiplexProgramSummary.wrap(buildAwsValue())
}
object MultiplexProgramSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.MultiplexProgramSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.MultiplexProgramSummary =
      zio.aws.medialive.model.MultiplexProgramSummary(
        channelId.map(value => value),
        programName.map(value => value)
      )
    def channelId: Option[__string]
    def programName: Option[__string]
    def getChannelId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("channelId", channelId)
    def getProgramName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("programName", programName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.MultiplexProgramSummary
  ) extends zio.aws.medialive.model.MultiplexProgramSummary.ReadOnly {
    override val channelId: Option[__string] =
      scala.Option(impl.channelId()).map(value => value: __string)
    override val programName: Option[__string] =
      scala.Option(impl.programName()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.MultiplexProgramSummary
  ): zio.aws.medialive.model.MultiplexProgramSummary.ReadOnly = new Wrapper(
    impl
  )
}
