package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{
  __integerMin0Max100000000,
  __integerMin0Max65535,
  __integerMin1000000Max100000000,
  __integerMin800Max3000
}
import scala.jdk.CollectionConverters._
final case class MultiplexSettings(
    maximumVideoBufferDelayMilliseconds: Option[__integerMin800Max3000] = None,
    transportStreamBitrate: __integerMin1000000Max100000000,
    transportStreamId: __integerMin0Max65535,
    transportStreamReservedBitrate: Option[__integerMin0Max100000000] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.MultiplexSettings = {
    import MultiplexSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.MultiplexSettings
      .builder()
      .optionallyWith(
        maximumVideoBufferDelayMilliseconds.map(value => value: Integer)
      )(_.maximumVideoBufferDelayMilliseconds)
      .transportStreamBitrate(transportStreamBitrate: Integer)
      .transportStreamId(transportStreamId: Integer)
      .optionallyWith(
        transportStreamReservedBitrate.map(value => value: Integer)
      )(_.transportStreamReservedBitrate)
      .build()
  }
  def asReadOnly: zio.aws.medialive.model.MultiplexSettings.ReadOnly =
    zio.aws.medialive.model.MultiplexSettings.wrap(buildAwsValue())
}
object MultiplexSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.MultiplexSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.MultiplexSettings =
      zio.aws.medialive.model.MultiplexSettings(
        maximumVideoBufferDelayMilliseconds.map(value => value),
        transportStreamBitrate,
        transportStreamId,
        transportStreamReservedBitrate.map(value => value)
      )
    def maximumVideoBufferDelayMilliseconds: Option[__integerMin800Max3000]
    def transportStreamBitrate: __integerMin1000000Max100000000
    def transportStreamId: __integerMin0Max65535
    def transportStreamReservedBitrate: Option[__integerMin0Max100000000]
    def getMaximumVideoBufferDelayMilliseconds
        : ZIO[Any, AwsError, __integerMin800Max3000] =
      AwsError.unwrapOptionField(
        "maximumVideoBufferDelayMilliseconds",
        maximumVideoBufferDelayMilliseconds
      )
    def getTransportStreamBitrate
        : ZIO[Any, Nothing, __integerMin1000000Max100000000] =
      ZIO.succeed(transportStreamBitrate)
    def getTransportStreamId: ZIO[Any, Nothing, __integerMin0Max65535] =
      ZIO.succeed(transportStreamId)
    def getTransportStreamReservedBitrate
        : ZIO[Any, AwsError, __integerMin0Max100000000] =
      AwsError.unwrapOptionField(
        "transportStreamReservedBitrate",
        transportStreamReservedBitrate
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.MultiplexSettings
  ) extends zio.aws.medialive.model.MultiplexSettings.ReadOnly {
    override val maximumVideoBufferDelayMilliseconds
        : Option[__integerMin800Max3000] = scala
      .Option(impl.maximumVideoBufferDelayMilliseconds())
      .map(value => value: __integerMin800Max3000)
    override val transportStreamBitrate: __integerMin1000000Max100000000 =
      impl.transportStreamBitrate(): __integerMin1000000Max100000000
    override val transportStreamId: __integerMin0Max65535 =
      impl.transportStreamId(): __integerMin0Max65535
    override val transportStreamReservedBitrate
        : Option[__integerMin0Max100000000] = scala
      .Option(impl.transportStreamReservedBitrate())
      .map(value => value: __integerMin0Max100000000)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.MultiplexSettings
  ): zio.aws.medialive.model.MultiplexSettings.ReadOnly = new Wrapper(impl)
}
