package zio.aws.medialive.model
import scala.jdk.CollectionConverters._
sealed trait MultiplexState {
  def unwrap: software.amazon.awssdk.services.medialive.model.MultiplexState
}
object MultiplexState {
  def wrap(
      value: software.amazon.awssdk.services.medialive.model.MultiplexState
  ): zio.aws.medialive.model.MultiplexState = value match {
    case software.amazon.awssdk.services.medialive.model.MultiplexState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.medialive.model.MultiplexState.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.medialive.model.MultiplexState.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
    case software.amazon.awssdk.services.medialive.model.MultiplexState.IDLE =>
      val r = IDLE
      r
    case software.amazon.awssdk.services.medialive.model.MultiplexState.STARTING =>
      val r = STARTING
      r
    case software.amazon.awssdk.services.medialive.model.MultiplexState.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.medialive.model.MultiplexState.RECOVERING =>
      val r = RECOVERING
      r
    case software.amazon.awssdk.services.medialive.model.MultiplexState.STOPPING =>
      val r = STOPPING
      r
    case software.amazon.awssdk.services.medialive.model.MultiplexState.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.medialive.model.MultiplexState.DELETED =>
      val r = DELETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.medialive.model.MultiplexState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.MultiplexState =
      software.amazon.awssdk.services.medialive.model.MultiplexState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.medialive.model.MultiplexState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.MultiplexState =
      software.amazon.awssdk.services.medialive.model.MultiplexState.CREATING
  }
  case object CREATE_FAILED extends zio.aws.medialive.model.MultiplexState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.MultiplexState =
      software.amazon.awssdk.services.medialive.model.MultiplexState.CREATE_FAILED
  }
  case object IDLE extends zio.aws.medialive.model.MultiplexState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.MultiplexState =
      software.amazon.awssdk.services.medialive.model.MultiplexState.IDLE
  }
  case object STARTING extends zio.aws.medialive.model.MultiplexState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.MultiplexState =
      software.amazon.awssdk.services.medialive.model.MultiplexState.STARTING
  }
  case object RUNNING extends zio.aws.medialive.model.MultiplexState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.MultiplexState =
      software.amazon.awssdk.services.medialive.model.MultiplexState.RUNNING
  }
  case object RECOVERING extends zio.aws.medialive.model.MultiplexState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.MultiplexState =
      software.amazon.awssdk.services.medialive.model.MultiplexState.RECOVERING
  }
  case object STOPPING extends zio.aws.medialive.model.MultiplexState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.MultiplexState =
      software.amazon.awssdk.services.medialive.model.MultiplexState.STOPPING
  }
  case object DELETING extends zio.aws.medialive.model.MultiplexState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.MultiplexState =
      software.amazon.awssdk.services.medialive.model.MultiplexState.DELETING
  }
  case object DELETED extends zio.aws.medialive.model.MultiplexState {
    override def unwrap
        : software.amazon.awssdk.services.medialive.model.MultiplexState =
      software.amazon.awssdk.services.medialive.model.MultiplexState.DELETED
  }
}
