package zio.aws.medialive.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.medialive.model.primitives.{
  __integerMinNegative5Max5,
  __integerMin100000Max100000000
}
import scala.jdk.CollectionConverters._
final case class MultiplexStatmuxVideoSettings(
    maximumBitrate: Option[__integerMin100000Max100000000] = None,
    minimumBitrate: Option[__integerMin100000Max100000000] = None,
    priority: Option[__integerMinNegative5Max5] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.medialive.model.MultiplexStatmuxVideoSettings = {
    import MultiplexStatmuxVideoSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.medialive.model.MultiplexStatmuxVideoSettings
      .builder()
      .optionallyWith(maximumBitrate.map(value => value: Integer))(
        _.maximumBitrate
      )
      .optionallyWith(minimumBitrate.map(value => value: Integer))(
        _.minimumBitrate
      )
      .optionallyWith(priority.map(value => value: Integer))(_.priority)
      .build()
  }
  def asReadOnly
      : zio.aws.medialive.model.MultiplexStatmuxVideoSettings.ReadOnly =
    zio.aws.medialive.model.MultiplexStatmuxVideoSettings.wrap(buildAwsValue())
}
object MultiplexStatmuxVideoSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.medialive.model.MultiplexStatmuxVideoSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.medialive.model.MultiplexStatmuxVideoSettings =
      zio.aws.medialive.model.MultiplexStatmuxVideoSettings(
        maximumBitrate.map(value => value),
        minimumBitrate.map(value => value),
        priority.map(value => value)
      )
    def maximumBitrate: Option[__integerMin100000Max100000000]
    def minimumBitrate: Option[__integerMin100000Max100000000]
    def priority: Option[__integerMinNegative5Max5]
    def getMaximumBitrate: ZIO[Any, AwsError, __integerMin100000Max100000000] =
      AwsError.unwrapOptionField("maximumBitrate", maximumBitrate)
    def getMinimumBitrate: ZIO[Any, AwsError, __integerMin100000Max100000000] =
      AwsError.unwrapOptionField("minimumBitrate", minimumBitrate)
    def getPriority: ZIO[Any, AwsError, __integerMinNegative5Max5] =
      AwsError.unwrapOptionField("priority", priority)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.medialive.model.MultiplexStatmuxVideoSettings
  ) extends zio.aws.medialive.model.MultiplexStatmuxVideoSettings.ReadOnly {
    override val maximumBitrate: Option[__integerMin100000Max100000000] = scala
      .Option(impl.maximumBitrate())
      .map(value => value: __integerMin100000Max100000000)
    override val minimumBitrate: Option[__integerMin100000Max100000000] = scala
      .Option(impl.minimumBitrate())
      .map(value => value: __integerMin100000Max100000000)
    override val priority: Option[__integerMinNegative5Max5] = scala
      .Option(impl.priority())
      .map(value => value: __integerMinNegative5Max5)
  }
  def wrap(
      impl: software.amazon.awssdk.services.medialive.model.MultiplexStatmuxVideoSettings
  ): zio.aws.medialive.model.MultiplexStatmuxVideoSettings.ReadOnly =
    new Wrapper(impl)
}
